/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.swing;

import javax.swing.JLabel;

import org.simantics.scenegraph.ExportableWidget.OutputWidget;

@OutputWidget("value")
public class LabelNode extends ComponentNode<JLabel> {
    /**
     * 
     */
    private static final long serialVersionUID = 7073028693751719102L;

    protected String value = "";
    
    @Override
    public void init() {
        component = new JLabel(value);
        super.init();
    }

    @SyncField("value")
    public void setText(String value) {
        this.value = value;
        // RemoteViewer does not have component initialized
        if (component != null) {
            component.setText(value);
        }
    }
    
    public String getText() {
        return value;
    }
}
