/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;

/**
 * @author Tuukka Lehtonen
 */
public class RelationshipNode2 extends G2DNode implements Decoration {

    private static final long serialVersionUID = 3517235896431855937L;

    public static transient double PADDING = 1;

    protected Stroke boxStroke = null;
    protected Stroke lineStroke = null;
    protected Color boxColor = null;
    protected Color lineColor = null;
    protected Point2D p1 = null;
    protected Point2D p2 = null;

    private transient Rectangle2D boundsInLocal = null;
    private transient float phase = 0;
    private transient Line2D line = new Line2D.Double();

    @SyncField({"linestroke", "linecolor", "p1", "p2"})
    public void init(Stroke lineStroke, Color lineColor, Point2D p1, Point2D p2) {
        this.lineStroke = lineStroke;
        this.lineColor = lineColor;
        this.p1 = p1;
        this.p2 = p2;
        this.boundsInLocal = calculateLocalBounds();
    }

    @Override
    public void render(Graphics2D g) {
        if (p1 == null || p2 == null)
            return;

        phase += 0.2;
        if (phase > 10)
            phase -= 10;

        float scale = (float) (1.0 / GeometryUtils.getScale(g.getTransform()));
        float scaledPhase = scale * phase;

        if (lineStroke != null && lineColor != null) {
            if (lineStroke != boxStroke)
                g.setStroke(GeometryUtils.scaleAndOffsetStroke(lineStroke, scale, scaledPhase));
            if (lineColor != boxColor)
                g.setColor(lineColor);
            line.setLine(p1, p2);
            g.draw(line);
        }
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return boundsInLocal;
    }

    private Rectangle2D calculateLocalBounds() {
        if (p1 == null || p2 == null)
            return null;
        Rectangle2D r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(p1, p2);
        return r;
    }

}
