/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.events.command;

import java.awt.geom.Point2D;

/**
 * Static commands are listed in this class
 * 
 * @see Command
 * @see CommandKeyBinding Command to key binding and default bindings
 * @see KeyToCommand Participant that transforms key presses to commands
 * 
 * @author Toni Kalajainen
 */
public class Commands {

    public static final Command ENABLE_PAINTING = new Command("enablePainting");

    public static final Command FULL_SCREEN = new Command("fullScreen");

    public static final Command PAN_LEFT = new Command("panLeft");
    public static final Command PAN_RIGHT = new Command("panRight");
    public static final Command PAN_UP = new Command("panUp");
    public static final Command PAN_DOWN = new Command("panDown");
    public static final Command ZOOM_IN = new Command("zoomIn");
    public static final Command ZOOM_OUT = new Command("zoomOut");
    public static final Command ZOOM_TO_FIT = new Command("zoomToFit");
    public static final Command ZOOM_TO_FIT_HORIZ = new Command("org.simantics.chart.zoomToFitHoriz");
    public static final Command ZOOM_TO_FIT_VERT = new Command("org.simantics.chart.zoomToFitVert");
    public static final Command ZOOM_TO_SELECTION = new Command("zoomToSelection");
    public static final Command AUTOSCALE = new Command("org.simantics.chart.autoscale");
    public static final Command ZOOM_TO_AREA = new Command("zoomToArea");
    public static final Command ZOOM_TO_PAGE = new Command("zoomToPage");

    public static final Command UNDO = new Command("org.eclipse.ui.edit.undo");
    public static final Command REDO = new Command("org.eclipse.ui.edit.redo");

    public static final Command CLOSE = new Command("org.eclipse.ui.file.close");
    public static final Command IMPORT = new Command("org.eclipse.ui.file.import");
    public static final Command EXPORT = new Command("org.eclipse.ui.file.export");
    public static final Command PRINT = new Command("org.eclipse.ui.file.print");
    public static final Command PDFPRINT = new Command("org.simantics.ui.file.pdfprint");
    public static final Command REFRESH = new Command("org.eclipse.ui.file.refresh");

    public static final Command BACK = new Command("org.eclipse.ui.navigate.back");
    public static final Command FORWARD = new Command("org.eclipse.ui.navigate.forward");
    public static final Command UP = new Command("org.eclipse.ui.navigate.up");

    public static final Command RENAME = new Command("org.eclipse.ui.edit.rename");

    public static final Command DELETE = new Command("org.eclipse.ui.edit.delete");
    public static final Command CUT = new Command("org.eclipse.ui.edit.cut");
    public static final Command COPY = new Command("org.eclipse.ui.edit.copy");
    public static final Command PASTE = new Command("org.eclipse.ui.edit.paste");
    public static final Command ROTATE_ELEMENT_CW = new Command("rotateElementCW");
    public static final Command ROTATE_ELEMENT_CCW = new Command("rotateElementCCW");
    public static final Command FLIP_ELEMENT_HORIZONTAL = new Command("flipElementHorizontal");
    public static final Command FLIP_ELEMENT_VERTICAL = new Command("flipElementVertical");
    public static final Command SCALE_ELEMENT = new Command("scaleElement");

    public static final Command ROTATE_CANVAS_CW = new Command("rotateCW");
    public static final Command ROTATE_CANVAS_CCW = new Command("rotateCCW");

    public static final Command CANCEL = new Command("cancel");
    public static final Command SELECT_ALL = new Command("org.eclipse.ui.edit.selectAll");
    public static final Command INVERT_SELECTION = new Command("invertSelection");
    public static final Command EXPAND_SELECTION = new Command("expandSelection");

    public static final Command BRING_TO_TOP = new Command("bringToTop");
    public static final Command SEND_TO_BOTTOM = new Command("sendToBottom");
    public static final Command BRING_UP = new Command("bringUp");
    public static final Command SEND_DOWN = new Command("sendDown");

    public static final Command GRID_TOGGLE = new Command("gridToggle");
    public static final Command GRID_ENABLE = new Command("gridEnable");
    public static final Command GRID_DISABLE = new Command("gridDisable");

    public static final Command SNAP_TOGGLE = new Command("snapToggle");
    public static final Command SNAP_ENABLE = new Command("snapEnable");
    public static final Command SNAP_DISABLE = new Command("snapDisable");

    public static final Command RULER_TOGGLE = new Command("rulerToggle");
    public static final Command RULER_ENABLE = new Command("rulerEnable");
    public static final Command RULER_DISABLE = new Command("rulerDisable");
    
    public static final Command MAP_TOGGLE = new Command("mapToggle");
    public static final Command MAP_ENABLE = new Command("mapEnable");
    public static final Command MAP_DISABLE = new Command("mapDisable");

    public static final Command ROTATE_CANVAS_CW_GRAB = new Command("grabRotateCW");
    public static final Command ROTATE_CANVAS_CCW_GRAB = new Command("grabRotateCCW");

    public static final Command ROTATE_CANVAS_CW_RELEASE = new Command("releaseRotateCW");
    public static final Command ROTATE_CANVAS_CCW_RELEASE = new Command("releaseRotateCCW");

    public static final Command SPLIT_CONNECTION = new Command("splitConnection");
    public static final Command JOIN_FLAGS = new Command("joinFlags");

    public static final Command FOCUS_TOOLTIP = new Command("focusTooltip");

    public static final Command COPY_AS_SVG = new Command("copyAsSVG");
    
    public static Command showPopup(Point2D atControlPosition) {
        return new ShowPopup(atControlPosition);
    }

}
