package org.simantics.scenegraph.profile.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

import org.simantics.db.Resource;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.Style;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.runtime.tuple.Tuple3;

/**
 * @author Antti Villberg
 * @since 1.48.0
 */
public class ProfileObserverData {

    private static ProfileObserverData INSTANCE;

    protected final Map<Tuple, Object> values   = new ConcurrentHashMap<>();

    private Map<Tuple3, ObserverGroupListener> listeners = new HashMap<>();
    
    private Map<Tuple2, Set<Group>> groups = new HashMap<>();

    public static ProfileObserverData getInstance() {
        if (INSTANCE == null) {
            synchronized (ProfileObserverData.class) {
                if (INSTANCE == null) {
                    INSTANCE = new ProfileObserverData();
                }
            }
        }
        return INSTANCE;
    }

    public void removeValue(Tuple t) {
        values.remove(t);
    }

    public void putValue(Tuple t, Object o) {
        values.put(t, o);
    }

    @SuppressWarnings("unchecked")
    public <T> T getValue(Tuple t) {
        return (T) values.get(t);
    }

    public void putListener(Style style, Resource runtime, Group group, ObserverGroupListener listener) {
        listeners.put(new Tuple3(style, runtime, group), listener);
        Set<Group> list = groups.get(new Tuple2(style, runtime));
        if(list == null) {
            list = new HashSet<>();
            groups.put(new Tuple2(style, runtime), list);
        }
        list.add(group);
    }

    public void removeListener(Style style, Resource runtime, Group group) {
        listeners.remove(new Tuple3(style, runtime, group));
        Set<Group> list = groups.get(new Tuple2(style, runtime));
        if(list != null) {
            list.remove(group);
            if(list.isEmpty())
                groups.remove(new Tuple2(style, runtime));
        }
    }

    public ObserverGroupListener getListener(Style style, Resource runtime, Group group) {
        return listeners.get(new Tuple3(style, runtime, group));
    }
    
    public boolean isActive(Style style, Resource runtime, Object item) {
        for(Group group : groups.get(new Tuple2(style, runtime))) {
            ObserverGroupListener listener = getListener(style, runtime, group);
            if(listener.hasItem(item))
                return true;
        }
        return false;
    }

    public void forEachListener(Consumer<ObserverGroupListener> c) {
        listeners.forEach((key, value) -> {
            c.accept(value);
        });
    }

}
