package org.simantics.scenegraph.profile;

import java.util.Collections;
import java.util.List;
import java.util.UUID;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class ProfileUtils {

	public static List<Resource> getProfileChildren(ReadGraph graph, Resource profile) throws DatabaseException {
		DiagramResource DIA = DiagramResource.getInstance(graph);
		Resource entries = graph.getPossibleObject(profile, DIA.HasEntries);
		if(entries == null) return Collections.emptyList();
		return getProfileChildrenFromEntries(graph, entries);
	}

	public static List<Resource> getProfileChildrenFromEntries(ReadGraph graph, Resource entries) throws DatabaseException {
		DiagramResource DIA = DiagramResource.getInstance(graph);
		return graph.getRelatedValue2(entries, DIA.Profile_children, entries);
	}

	public static Resource getPossibleProfileActivationState(ReadGraph graph, Resource runtimeDiagram, Resource profile) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);
		Resource conf = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
		if(conf == null) return null;
		Resource indexRoot = graph.syncRequest(new PossibleIndexRoot(conf));
		if(indexRoot == null) return null;
		// Find existing state
		for(Resource state : graph.syncRequest(new ObjectsWithType(indexRoot, L0.ConsistsOf, DIA.ProfileActivationState))) {
			Resource ref = graph.getPossibleObject(state, DIA.ProfileActivationState_HasProfile);
			if(profile.equals(ref)) return state;
		}
		return null;

	}

	public static Resource claimProfileActivationState(WriteGraph graph, Resource runtimeDiagram, Resource runtimeProfile, Resource entry) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);
		Resource conf = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
		if(conf == null) return null;
		Resource indexRoot = graph.syncRequest(new PossibleIndexRoot(conf));
		if(indexRoot == null) return null;
		// Find existing state
		for(Resource state : graph.syncRequest(new ObjectsWithType(indexRoot, L0.ConsistsOf, DIA.ProfileActivationState))) {
			Resource profile = graph.getPossibleObject(state, DIA.ProfileActivationState_HasProfile);
			if(profile.equals(runtimeProfile)) return state;
		}
		// Create new state
		Resource state = graph.newResource();
		graph.claim(state, L0.InstanceOf, DIA.ProfileActivationState);
		graph.claimLiteral(state, L0.HasName, L0.String, UUID.randomUUID().toString(), Bindings.STRING);
		graph.claim(state, DIA.ProfileActivationState_HasProfile, runtimeProfile);
		graph.claim(indexRoot, L0.ConsistsOf, state);
		return state;
	}

	public static boolean isActive(ReadGraph graph, Resource runtimeDiagram, Resource profile, Resource entry) throws DatabaseException {
		DiagramResource DIA = DiagramResource.getInstance(graph);
		SimulationResource SIMU = SimulationResource.getInstance(graph);
		if(graph.isInstanceOf(entry, DIA.ProfileEntry)) {
			if(graph.isImmutable(profile)) {
				Resource state = getPossibleProfileActivationState(graph, runtimeDiagram, profile);
				if(state != null && graph.hasStatement(state, SIMU.IsActive, entry)) return true;
			} else {
				if(graph.hasStatement(profile, SIMU.IsActive, entry)) return true;
			}
		}
		return false;
	}

}
