/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.structural;

import java.util.List;

import org.simantics.db.Resource;

/**
 * Interface for structurally mapped Java objects.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public interface IStructuralObject {
	
	/**
	 * Context of an object. 
	 * @return
	 */
	public List<IStructuralObject> getContext();

	/**
	 * Sets object's context. Used by ObjMap, don't touch. 
	 * @param object
	 */
	public void setContext(List<IStructuralObject> object);
	
	/**
	 * Return type resource for Structural instances. For other objects returns null.
	 * @return
	 */
	public Resource getType();
	
	/**
	 * Sets object's type. Used by ObjMap, don't touch.
	 * @param object
	 */
	public void setType(Resource type);
}
