/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.schema;

import org.simantics.db.ReadGraph;
import org.simantics.objmap.exceptions.MappingException;

/**
 * Specifies the link types of new elements added to a mapping.
 * @author Hannu Niemist
 */
public interface IMappingSchema<Domain,Range> {
    /**
     * @return Link type that should be used for the element.
     */
	ILinkType<Domain,Range> linkTypeOfDomainElement(ReadGraph g, Domain element) throws MappingException;
	
	/**
     * @return Link type that should be used for the element.
     */
	ILinkType<Domain,Range> linkTypeOfRangeElement(Range element) throws MappingException;
}
