/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.nativemem.internal.win;

import org.simantics.nativemem.ProcessMemoryInfo;
import org.simantics.nativemem.internal.Util;

public class ProcessMemoryCounters
implements ProcessMemoryInfo {
    public int PageFaultCount;
    public long PeakWorkingSetSize;
    public long WorkingSetSize;
    public long QuotaPeakPagedPoolUsage;
    public long QuotaPagedPoolUsage;
    public long QuotaPeakNonPagedPoolUsage;
    public long QuotaNonPagedPoolUsage;
    public long PagefileUsage;
    public long PeakPagefileUsage;
    public long PrivateUsage;

    public String toString() {
        return "ProcessMemoryCounters [PageFaultCount=" + this.PageFaultCount + ", PeakWorkingSetSize=" + this.PeakWorkingSetSize + ", WorkingSetSize=" + this.WorkingSetSize + ", QuotaPeakPagedPoolUsage=" + this.QuotaPeakPagedPoolUsage + ", QuotaPagedPoolUsage=" + this.QuotaPagedPoolUsage + ", QuotaPeakNonPagedPoolUsage=" + this.QuotaPeakNonPagedPoolUsage + ", QuotaNonPagedPoolUsage=" + this.QuotaNonPagedPoolUsage + ", PagefileUsage=" + this.PagefileUsage + ", PeakPagefileUsage=" + this.PeakPagefileUsage + ", PrivateUsage=" + this.PrivateUsage + "]";
    }

    @Override
    public String toHumanReadableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RSS                 ").append(Util.toMb(this.WorkingSetSize)).append("M / ").append(Util.toMb(this.PeakWorkingSetSize)).append("M").append(Util.NL).append("Paged/Nonpaged Pool ").append(Util.toKb(this.QuotaPagedPoolUsage)).append("K / ").append(Util.toKb(this.QuotaPeakPagedPoolUsage)).append("K  /  ").append(Util.toKb(this.QuotaNonPagedPoolUsage)).append("K / ").append(Util.toKb(this.QuotaPeakNonPagedPoolUsage)).append("K").append(Util.NL).append("Page File           ").append(Util.toMb(this.PagefileUsage)).append("M / ").append(Util.toMb(this.PeakPagefileUsage)).append("M (").append(this.PageFaultCount).append(" faults)");
        return sb.toString();
    }

    @Override
    public String headerRow() {
        return "RSS [MB]\tPeak RSS [MB]\tPaged Pool Usage [kB]\tPeak Paged Pool Usage [kB]\tNonpaged Pool Usage [kB]\tPeak Nonpaged Pool Usage [kB]\tPage File Usage [MB]\tPeak Page File Usage [MB]\tPage Faults";
    }

    @Override
    public String dataRow() {
        return Util.toMb(this.WorkingSetSize) + "\t" + Util.toMb(this.PeakWorkingSetSize) + "\t" + Util.toKb(this.QuotaPagedPoolUsage) + "\t" + Util.toKb(this.QuotaPeakPagedPoolUsage) + "\t" + Util.toKb(this.QuotaNonPagedPoolUsage) + "\t" + Util.toKb(this.QuotaPeakNonPagedPoolUsage) + "\t" + Util.toMb(this.PagefileUsage) + "\t" + Util.toMb(this.PeakPagefileUsage) + "\t" + this.PageFaultCount;
    }

    public static void main(String[] args) {
        System.out.println(new ProcessMemoryCounters().toHumanReadableString());
        System.out.println(new ProcessMemoryCounters().headerRow());
        System.out.println(new ProcessMemoryCounters().dataRow());
    }
}

