/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.nativemem;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.lang.reflect.InvocationTargetException;
import org.simantics.nativemem.ProcessMemoryInfo;
import org.simantics.nativemem.internal.Arch;
import org.simantics.nativemem.internal.CMemoryInfo;
import org.simantics.nativemem.internal.DummyProcessMemoryInfo;
import org.simantics.nativemem.internal.OS;
import org.simantics.nativemem.internal.Resource32;
import org.simantics.nativemem.internal.Resource64;
import org.simantics.nativemem.internal.linux.Stat;
import org.simantics.nativemem.internal.win.ProcessMemoryCounters;
import org.simantics.nativemem.internal.win.Psapi32;
import org.simantics.nativemem.internal.win.Psapi64;

public class NativeMem {
    public static ProcessMemoryInfo getMemoryInfo(ProcessMemoryInfo out) {
        switch (OS.calculate()) {
            case WINDOWS: {
                return NativeMem.getProcessMemoryCounters(out);
            }
            case APPLE: {
                return NativeMem.getCMemoryInfo(out);
            }
            case LINUX: {
                CMemoryInfo info = NativeMem.getCMemoryInfo(out);
                info.peakRSS *= 1024L;
                NativeMem.getCurrentRSS(info);
                return info;
            }
        }
        return DummyProcessMemoryInfo.INSTANCE;
    }

    private static ProcessMemoryCounters getProcessMemoryCounters(ProcessMemoryInfo out) {
        ProcessMemoryCounters counters = NativeMem.castOrCreate(out, ProcessMemoryCounters.class);
        WinNT.HANDLE proc = Kernel32.INSTANCE.GetCurrentProcess();
        switch (Arch.calculate()) {
            case X86: {
                Psapi32.PROCESS_MEMORY_COUNTERS_EX pmem = new Psapi32.PROCESS_MEMORY_COUNTERS_EX();
                boolean ok = Psapi32.INSTANCE.GetProcessMemoryInfo(proc, pmem, pmem.size());
                if (ok) {
                    pmem.writeTo(counters);
                }
                return counters;
            }
            case X86_64: {
                Psapi64.PROCESS_MEMORY_COUNTERS_EX pmem = new Psapi64.PROCESS_MEMORY_COUNTERS_EX();
                boolean ok = Psapi64.INSTANCE.GetProcessMemoryInfo(proc, pmem, pmem.size());
                if (ok) {
                    pmem.writeTo(counters);
                }
                return counters;
            }
        }
        return counters;
    }

    private static CMemoryInfo getCMemoryInfo(ProcessMemoryInfo out) {
        CMemoryInfo info = NativeMem.castOrCreate(out, CMemoryInfo.class);
        switch (Arch.calculate()) {
            case X86: {
                Resource32.Rusage rusage = new Resource32.Rusage();
                int ok = Resource32.INSTANCE.getrusage(0, rusage);
                if (ok == 0) {
                    rusage.writeTo(info);
                }
                return info;
            }
            case X86_64: {
                Resource64.Rusage rusage = new Resource64.Rusage();
                int ok = Resource64.INSTANCE.getrusage(0, rusage);
                if (ok == 0) {
                    rusage.writeTo(info);
                }
                return info;
            }
        }
        return info;
    }

    private static CMemoryInfo getCurrentRSS(ProcessMemoryInfo out) {
        CMemoryInfo info = NativeMem.castOrCreate(out, CMemoryInfo.class);
        switch (Arch.calculate()) {
            case X86: {
                long rss = Stat.getCurrentRSS(Resource32.INSTANCE);
                if (rss >= 0L) {
                    info.currentRSS = rss;
                }
                return info;
            }
            case X86_64: {
                long rss = Stat.getCurrentRSS(Resource64.INSTANCE);
                if (rss >= 0L) {
                    info.currentRSS = rss;
                }
                return info;
            }
        }
        return info;
    }

    private static <T> T castOrCreate(Object o, Class<T> clazz) {
        if (clazz.isInstance(o)) {
            return clazz.cast(o);
        }
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new Error("Class " + String.valueOf(clazz) + " does not have a public parameterless constructor", e);
        }
    }
}

