/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.msvc.runtime;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.runtime.Path;

public final class Runtimes {
    public static final String VC_2010 = "vc2010";
    static boolean vc100Initialized = false;

    public static void initialize(String vc) {
        OSType os = OSType.calculate();
        if (os == OSType.WINDOWS && VC_2010.equals(vc) && !vc100Initialized) {
            Runtimes.initializeVC100();
        }
    }

    static synchronized void initializeVC100() {
        try {
            System.loadLibrary("msvcr100");
            System.loadLibrary("msvcp100");
            vc100Initialized = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                String archStr = ARCHType.calculate().toString().toLowerCase();
                URL url = Runtimes.class.getResource(".");
                File dir = new File(URLDecoder.decode(url.getPath(), "UTF-8") + "../../../../../../org.simantics.msvc.runtime." + archStr);
                dir = new Path(dir.getAbsolutePath()).toFile();
                String vcr = new File(dir, "msvcr100.dll").getAbsolutePath();
                String vcp = new File(dir, "msvcp100.dll").getAbsolutePath();
                System.load(vcr);
                System.load(vcp);
                vc100Initialized = true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("UTF-8 not supported, impossible");
            }
        }
    }

    public static final class ARCHType
    extends Enum<ARCHType> {
        public static final /* enum */ ARCHType PPC = new ARCHType();
        public static final /* enum */ ARCHType PPC_64 = new ARCHType();
        public static final /* enum */ ARCHType SPARC = new ARCHType();
        public static final /* enum */ ARCHType X86 = new ARCHType();
        public static final /* enum */ ARCHType X86_64 = new ARCHType();
        public static final /* enum */ ARCHType UNKNOWN = new ARCHType();
        private static final /* synthetic */ ARCHType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ARCHType[]{PPC, PPC_64, SPARC, X86, X86_64, UNKNOWN};
        }

        public static ARCHType calculate() {
            String osArch = System.getProperty("os.arch");
            assert (osArch != null);
            if ((osArch = osArch.toLowerCase()).equals("i386") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("x86")) {
                return X86;
            }
            if (osArch.startsWith("amd64") || osArch.startsWith("x86_64")) {
                return X86_64;
            }
            if (osArch.equals("ppc")) {
                return PPC;
            }
            if (osArch.startsWith("ppc")) {
                return PPC_64;
            }
            if (osArch.startsWith("sparc")) {
                return SPARC;
            }
            return UNKNOWN;
        }

        public static ARCHType[] values() {
            ARCHType[] aRCHTypeArray = ENUM$VALUES;
            int n = aRCHTypeArray.length;
            ARCHType[] aRCHTypeArray2 = new ARCHType[n];
            System.arraycopy(ENUM$VALUES, 0, aRCHTypeArray2, 0, n);
            return aRCHTypeArray2;
        }

        public static ARCHType valueOf(String string) {
            return Enum.valueOf(ARCHType.class, string);
        }
    }

    public static final class OSType
    extends Enum<OSType> {
        public static final /* enum */ OSType APPLE = new OSType();
        public static final /* enum */ OSType LINUX = new OSType();
        public static final /* enum */ OSType SUN = new OSType();
        public static final /* enum */ OSType WINDOWS = new OSType();
        public static final /* enum */ OSType UNKNOWN = new OSType();
        private static final /* synthetic */ OSType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new OSType[]{APPLE, LINUX, SUN, WINDOWS, UNKNOWN};
        }

        public static OSType calculate() {
            String osName = System.getProperty("os.name");
            assert (osName != null);
            if ((osName = osName.toLowerCase()).startsWith("mac os x")) {
                return APPLE;
            }
            if (osName.startsWith("windows")) {
                return WINDOWS;
            }
            if (osName.startsWith("linux")) {
                return LINUX;
            }
            if (osName.startsWith("sun")) {
                return SUN;
            }
            return UNKNOWN;
        }

        public static OSType[] values() {
            OSType[] oSTypeArray = ENUM$VALUES;
            int n = oSTypeArray.length;
            OSType[] oSTypeArray2 = new OSType[n];
            System.arraycopy(ENUM$VALUES, 0, oSTypeArray2, 0, n);
            return oSTypeArray2;
        }

        public static OSType valueOf(String string) {
            return Enum.valueOf(OSType.class, string);
        }
    }
}

