/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.sharedontology.wizard;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import org.eclipse.ui.IMemento;
import org.simantics.utils.ui.workbench.StringMemento;

public final class Preferences {
    public static final String RECENT_SHARED_LIBRARY_IMPORT_LOCATIONS = "RECENT_SHARED_LIBRARY_IMPORT_LOCATIONS";
    public static final String RECENT_SHARED_LIBRARY_EXPORT_LOCATIONS = "RECENT_SHARED_LIBRARY_EXPORT_LOCATIONS";
    public static final String SHARED_LIBRARY_EXPORT_OVERWRITE = "SHARED_LIBRARY_EXPORT_OVERWRITE";
    public static final String EXPORT_INCLUDE_DEPENDENCIES = "EXPORT_INCLUDE_DEPENDENCIES";
    public static final String IMPORT_INCLUDE_DEPENDENCIES = "IMPORT_INCLUDE_DEPENDENCIES";
    private static final String TAG_PATH = "path";
    private static final String ATTR_NAME = "name";

    public static Deque<String> decodePaths(String recentPathsPref) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            StringMemento sm = new StringMemento(recentPathsPref);
            IMemento[] iMementoArray = sm.getChildren(TAG_PATH);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento m = iMementoArray[n2];
                String name = m.getString(ATTR_NAME);
                if (name != null && !name.isEmpty()) {
                    result.add(name);
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return result;
    }

    public static String encodePaths(Deque<String> recentPaths) {
        StringMemento sm = new StringMemento();
        for (String path : recentPaths) {
            IMemento m = sm.createChild(TAG_PATH);
            m.putString(ATTR_NAME, path);
        }
        return sm.toString();
    }

    public static <T> void removeDuplicates(Iterable<String> iter) {
        TreeSet<String> dups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Iterator<String> it = iter.iterator();
        while (it.hasNext()) {
            String path = it.next();
            if (dups.add(path)) continue;
            it.remove();
        }
    }
}

