/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.commandlog.PasteCommand;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.commandlog.Command;
import org.simantics.utils.commandlog.Commands;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.ISelectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardPasteHandler
extends AbstractHandler
implements IHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardPasteHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        PasteHandler handler = (PasteHandler)SimanticsUI.filterSingleSelection((ISelection)selection, PasteHandler.class);
        if (handler != null) {
            try {
                Resource target;
                Simantics.getSession().markUndoPoint();
                IRunnableWithProgress op = StandardPasteHandler.pasteResourceFromClipboard(handler);
                Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                new ProgressMonitorDialog(shell).run(true, true, op);
                if (Commands.isRecording() && (target = (Resource)ISelectionUtils.filterSingleSelection((Object)selection, Resource.class)) != null) {
                    Commands.record((Command)new PasteCommand(target));
                }
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t != null) {
                    ExceptionUtils.logAndShowError((String)"Paste Failed", (String)t.getMessage(), (Throwable)e);
                } else {
                    ExceptionUtils.logAndShowError((String)"Paste Failed", (String)"Paste failed for unknown reason.", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        return null;
    }

    public static IRunnableWithProgress pasteResourceFromClipboard(final PasteHandler handler) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        progress.beginTask("Copying", 100);
                        progress.worked(50);
                        progress.subTask("Please wait..");
                        handler.pasteFromClipboard(Simantics.getClipboard());
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        return op;
    }

    public static void pasteResourceFromClipboardWithoutMonitor(PasteHandler handler) {
        try {
            handler.pasteFromClipboard(Simantics.getClipboard());
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to paste resource from clipboard with handler {}", (Object)handler, (Object)e);
        }
    }

    public static <T> T getPasteHandlerFromResource(Resource resource, Class<T> assignableFrom) {
        try {
            return (T)Simantics.getSession().syncRequest((Read)new Adapter(resource, assignableFrom));
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to get paste handler from resource {}", (Object)resource, (Object)e);
            return null;
        }
    }
}

