/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.Page;
import org.simantics.diagram.layer.ILayersViewPage;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementLayerListener;
import org.simantics.g2d.element.handler.ElementLayers;
import org.simantics.g2d.layers.IEditableLayer;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayers;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.g2d.layers.SimpleLayer;
import org.simantics.modeling.ui.diagramEditor.Messages;
import org.simantics.utils.datastructures.Arrays;
import org.simantics.utils.datastructures.disposable.IDisposable;
import org.simantics.utils.datastructures.disposable.IDisposeListener;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.ui.ISelectionUtils;

public class DiagramLayersPage
extends Page
implements ILayersViewPage {
    private static final String TEXT_IGNORE_FOCUS_SETTINGS = Messages.DiagramLayersPage_FocusAll;
    private static final String TOOLTIP_IGNORE_FOCUS_SETTINGS = Messages.DiagramLayersPage_FocusAllTT;
    private static final String TEXT_IGNORE_VISIBILITY_SETTINGS = Messages.DiagramLayersPage_ShowAll;
    private static final String TOOLTIP_IGNORE_VISIBILITY_SETTINGS = Messages.DiagramLayersPage_ShowAllTT;
    private final ICanvasContext context;
    private CheckboxTreeViewer viewer;
    private Button ignoreVisibilityButton;
    private Button ignoreFocusButton;
    private Composite composite;
    private TreeEditor editor;
    private Collection<IElement> elements = Collections.emptySet();
    private ILayersEditor layers;
    private final IHintListener selectionListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            Collection<Object> es = Collections.emptySet();
            if (newValue instanceof Collection) {
                Collection coll = (Collection)newValue;
                es = new ArrayList(coll.size());
                for (Object o : coll) {
                    if (!(o instanceof IElement)) {
                        return;
                    }
                    es.add((IElement)o);
                }
                if (es.isEmpty()) {
                    es = Collections.emptySet();
                }
            }
            DiagramLayersPage.this.elements = es;
            this.redraw();
        }

        private void redraw() {
            if (DiagramLayersPage.this.viewer != null) {
                DiagramLayersPage.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).DiagramLayersPage.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        (this).DiagramLayersPage.this.viewer.getControl().redraw();
                    }
                });
            }
        }
    };
    private final IDisposeListener contextDisposeListener = new IDisposeListener(){

        public void onDisposed(IDisposable sender) {
            if (DiagramLayersPage.this.getControl() != null) {
                DiagramLayersPage.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DiagramLayersPage.this.dispose();
                    }
                });
            }
        }
    };
    private ILayers.ILayersListener layersListener = new ILayers.ILayersListener(){

        public void changed() {
            this.scheduleRefresh();
        }

        void scheduleRefresh() {
            DiagramLayersPage.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    (this).DiagramLayersPage.this.viewer.refresh();
                    (this).DiagramLayersPage.this.ignoreVisibilityButton.setSelection((this).DiagramLayersPage.this.layers.getIgnoreVisibilitySettings());
                    (this).DiagramLayersPage.this.ignoreFocusButton.setSelection((this).DiagramLayersPage.this.layers.getIgnoreFocusSettings());
                    if (!(this).DiagramLayersPage.this.context.isDisposed()) {
                        (this).DiagramLayersPage.this.context.getContentContext().setDirty();
                    }
                }
            });
        }
    };

    Boolean getAttribute(IElement e, ILayer layer, Attribute attribute) {
        ElementClass ec = e.getElementClass();
        for (ElementLayers el : ec.getItemsByClass(ElementLayers.class)) {
            switch (attribute) {
                case Visible: {
                    return el.isVisible(e, layer);
                }
                case Focusable: {
                    return el.isFocusable(e, layer);
                }
            }
        }
        return null;
    }

    Tristate getJointAttribute(Collection<IElement> elements, ILayer layer, Attribute attribute) {
        Tristate state = null;
        for (IElement e : elements) {
            Boolean attr = this.getAttribute(e, layer, attribute);
            if (attr == null) continue;
            state = state == null ? Tristate.to(attr) : state.merge(Tristate.to(attr));
        }
        return state;
    }

    void setAttribute(Collection<IElement> elements, ILayer layer, Attribute attribute, boolean value) {
        IDiagram diagram = (IDiagram)this.context.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        ElementLayerListener elementLayerListener = (ElementLayerListener)diagram.getHint(DiagramHints.KEY_ELEMENT_LAYER_LISTENER);
        switch (attribute) {
            case Visible: {
                for (IElement e : elements) {
                    Set elementLayers = (Set)e.getHint(ElementHints.KEY_VISIBLE_LAYERS);
                    if (elementLayers != null) {
                        if (value) {
                            elementLayers.add(layer);
                        } else {
                            elementLayers.remove(layer);
                        }
                    }
                    elementLayerListener.visibilityChanged(e, layer, value);
                }
                break;
            }
            case Focusable: {
                for (IElement e : elements) {
                    Set elementLayers = (Set)e.getHint(ElementHints.KEY_FOCUS_LAYERS);
                    if (elementLayers != null) {
                        if (value) {
                            elementLayers.add(layer);
                        } else {
                            elementLayers.remove(layer);
                        }
                    }
                    elementLayerListener.focusabilityChanged(e, layer, value);
                }
                break;
            }
        }
        elementLayerListener.flush();
    }

    public DiagramLayersPage(ICanvasContext context) {
        this.context = context;
        context.getDefaultHintContext().addKeyHintListener((IHintContext.Key)Selection.SELECTION0, this.selectionListener);
        context.addDisposeListener(this.contextDisposeListener);
    }

    public void dispose() {
        this.context.getDefaultHintContext().removeKeyHintListener((IHintContext.Key)Selection.SELECTION0, this.selectionListener);
        this.context.removeDisposeListener(this.contextDisposeListener);
        if (this.layers != null && this.layersListener != null) {
            this.layers.removeLayersListener(this.layersListener);
            this.layersListener = null;
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.composite);
        IDiagram diagram = (IDiagram)this.context.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        if (diagram != null) {
            this.onDiagramSet(diagram);
        }
        this.context.getDefaultHintContext().addKeyHintListener(DiagramHints.KEY_DIAGRAM, new IHintListener(){

            public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                IDiagram diagram = (IDiagram)newValue;
                DiagramLayersPage.this.onDiagramSet(diagram);
            }

            public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
            }
        });
    }

    private void onDiagramSet(final IDiagram diagram) {
        if (diagram != null) {
            this.layers = (ILayersEditor)diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
            if (this.layers != null) {
                this.initialize(this.layers, diagram);
            }
            diagram.addKeyHintListener(DiagramHints.KEY_LAYERS_EDITOR, new IHintListener(){

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    if (newValue != null) {
                        DiagramLayersPage.this.initialize(DiagramLayersPage.this.layers, diagram);
                    }
                }

                public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
                }
            });
        }
    }

    private void initialize(final ILayersEditor layers, final IDiagram diagram) {
        this.composite.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiagramLayersPage.this.initialize2(layers, diagram);
            }
        });
    }

    private static String findFreshName(ILayers layers, String proposal) {
        Set all = layers.getLayers();
        Object name = proposal;
        int i = 1;
        while (true) {
            boolean match = false;
            for (ILayer layer : all) {
                if (!((String)name).equals(layer.getName())) continue;
                match = true;
                break;
            }
            if (!match) {
                return name;
            }
            name = proposal + " " + ++i;
        }
    }

    private void initialize2(final ILayersEditor layers, IDiagram diagram) {
        layers.addLayersListener(this.layersListener);
        GridData gridData = new GridData(4, 4, true, false);
        this.composite.setLayoutData((Object)gridData);
        this.composite.setLayout((Layout)new GridLayout(3, false));
        this.ignoreVisibilityButton = new Button(this.composite, 32);
        this.ignoreVisibilityButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.ignoreVisibilityButton.setText(TEXT_IGNORE_VISIBILITY_SETTINGS);
        this.ignoreVisibilityButton.setToolTipText(TOOLTIP_IGNORE_VISIBILITY_SETTINGS);
        this.ignoreVisibilityButton.setSelection(layers.getIgnoreVisibilitySettings());
        this.ignoreVisibilityButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                layers.setIgnoreVisibilitySettings(!layers.getIgnoreVisibilitySettings());
                DiagramLayersPage.this.context.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).DiagramLayersPage.this.context.isDisposed()) {
                            return;
                        }
                        (this).DiagramLayersPage.this.context.getContentContext().setDirty();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.ignoreFocusButton = new Button(this.composite, 32);
        this.ignoreFocusButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.ignoreFocusButton.setText(TEXT_IGNORE_FOCUS_SETTINGS);
        this.ignoreFocusButton.setToolTipText(TOOLTIP_IGNORE_FOCUS_SETTINGS);
        this.ignoreFocusButton.setSelection(layers.getIgnoreFocusSettings());
        this.ignoreFocusButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                layers.setIgnoreFocusSettings(!layers.getIgnoreFocusSettings());
                DiagramLayersPage.this.context.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).DiagramLayersPage.this.context.isDisposed()) {
                            return;
                        }
                        (this).DiagramLayersPage.this.context.getContentContext().setDirty();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button addButton = new Button(this.composite, 0);
        addButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        addButton.setText(Messages.DiagramLayersPage_New);
        addButton.setToolTipText(Messages.DiagramLayersPage_NewTT);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String name = DiagramLayersPage.findFreshName((ILayers)layers, Messages.DiagramLayersPage_NewRole);
                SimpleLayer layer = new SimpleLayer(name);
                layers.addLayer((ILayer)layer);
                layers.activate((ILayer)layer);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer = new CheckboxTreeViewer(this.composite, 67584);
        GridDataFactory.fillDefaults().grab(true, true).span(4, 1).applyTo(this.viewer.getControl());
        this.viewer.getControl().setToolTipText(Messages.DiagramLayersPage_SelectTT);
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.getTree().setHeaderVisible(true);
        this.editor = new TreeEditor(this.viewer.getTree());
        final TreeColumn column1 = new TreeColumn(this.viewer.getTree(), 16384);
        column1.setText(Messages.DiagramLayersPage_Role);
        column1.setWidth(100);
        final TreeColumn column2 = new TreeColumn(this.viewer.getTree(), 16384);
        column2.setText(Messages.DiagramLayersPage_Show);
        column2.setWidth(50);
        final TreeColumn column3 = new TreeColumn(this.viewer.getTree(), 16384);
        column3.setText(Messages.DiagramLayersPage_Focus);
        column3.setWidth(50);
        this.viewer.getTree().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Tree tree = DiagramLayersPage.this.viewer.getTree();
                Point size = tree.getSize();
                int w = Math.max(size.x - 100 - tree.getBorderWidth() * 2, 30);
                column1.setWidth(w);
            }
        });
        this.viewer.getTree().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (!(event.index != 1 && event.index != 2 || DiagramLayersPage.this.elements.isEmpty())) {
                    ILayer[] lz = layers.getLayers().toArray(new ILayer[0]);
                    TreeItem item = (TreeItem)event.item;
                    int index = DiagramLayersPage.this.viewer.getTree().indexOf(item);
                    int width = 0;
                    if (event.index == 1) {
                        width = column2.getWidth() - 1;
                    }
                    if (event.index == 2) {
                        width = column3.getWidth() - 1;
                    }
                    Attribute attribute = Attribute.Visible;
                    if (event.index == 2) {
                        attribute = Attribute.Focusable;
                    }
                    Tristate state = DiagramLayersPage.this.getJointAttribute(DiagramLayersPage.this.elements, lz[index], attribute);
                    Color color = null;
                    if (state == null) {
                        color = DiagramLayersPage.this.viewer.getTree().getDisplay().getSystemColor(15);
                    } else {
                        switch (state) {
                            case False: {
                                color = DiagramLayersPage.this.viewer.getTree().getDisplay().getSystemColor(3);
                                break;
                            }
                            case True: {
                                color = DiagramLayersPage.this.viewer.getTree().getDisplay().getSystemColor(5);
                                break;
                            }
                            case Both: {
                                color = DiagramLayersPage.this.viewer.getTree().getDisplay().getSystemColor(15);
                            }
                        }
                    }
                    GC gc = event.gc;
                    Color foreground = gc.getForeground();
                    Color background = gc.getBackground();
                    gc.setBackground(color);
                    gc.setForeground(DiagramLayersPage.this.viewer.getTree().getDisplay().getSystemColor(2));
                    gc.fillRectangle(event.x, event.y, width - 1, event.height - 1);
                    Rectangle rect2 = new Rectangle(event.x, event.y, width - 1, event.height - 1);
                    gc.drawRectangle(rect2);
                    gc.setForeground(background);
                    gc.setBackground(foreground);
                }
            }
        });
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000B) {
                    TreeItem[] items = DiagramLayersPage.this.viewer.getTree().getSelection();
                    if (items.length != 1) {
                        return;
                    }
                    TreeItem item = items[0];
                    ILayer layer = (ILayer)ISelectionUtils.filterSingleSelection((Object)DiagramLayersPage.this.viewer.getSelection(), ILayer.class);
                    if (layer == null) {
                        return;
                    }
                    DiagramLayersPage.this.startEditing(layer, item);
                } else if (event.keyCode == 127) {
                    DiagramLayersPage.this.removeSelectedLayers();
                }
            }
        });
        this.viewer.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (DiagramLayersPage.this.viewer.getControl().isDisposed()) {
                    return;
                }
                Point pt = new Point(event.x, event.y);
                TreeItem item = DiagramLayersPage.this.viewer.getTree().getItem(pt);
                if (item == null) {
                    return;
                }
                int index = DiagramLayersPage.this.viewer.getTree().indexOf(item);
                ILayer[] lz = layers.getLayers().toArray(new ILayer[0]);
                ILayer layer = lz[index];
                Rectangle rect = item.getBounds(0);
                if (event.count == 2 && rect.contains(pt)) {
                    DiagramLayersPage.this.startEditing(layer, item);
                    return;
                }
                if (DiagramLayersPage.this.elements.isEmpty()) {
                    return;
                }
                rect = item.getBounds(1);
                if (rect.contains(pt)) {
                    Tristate state = DiagramLayersPage.this.getJointAttribute(DiagramLayersPage.this.elements, layer, Attribute.Visible);
                    DiagramLayersPage.this.setAttribute(DiagramLayersPage.this.elements, layer, Attribute.Visible, state.toggle().toBoolean());
                    this.refresh();
                    return;
                }
                Rectangle rect2 = item.getBounds(2);
                if (rect2.contains(pt)) {
                    Tristate state = DiagramLayersPage.this.getJointAttribute(DiagramLayersPage.this.elements, layer, Attribute.Focusable);
                    DiagramLayersPage.this.setAttribute(DiagramLayersPage.this.elements, layer, Attribute.Focusable, state.toggle().toBoolean());
                    this.refresh();
                    return;
                }
            }

            private void refresh() {
                DiagramLayersPage.this.viewer.getControl().redraw();
                DiagramLayersPage.this.context.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).DiagramLayersPage.this.context.isDisposed()) {
                            return;
                        }
                        (this).DiagramLayersPage.this.context.getContentContext().setDirty();
                    }
                });
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ILayer layer = (ILayer)event.getElement();
                if (event.getChecked()) {
                    layers.activate(layer);
                } else {
                    layers.deactivate(layer);
                }
                DiagramLayersPage.this.viewer.setSubtreeChecked(event.getElement(), event.getChecked());
                DiagramLayersPage.this.context.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).DiagramLayersPage.this.context.isDisposed()) {
                            return;
                        }
                        (this).DiagramLayersPage.this.context.getContentContext().setDirty();
                    }
                });
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return layers.getLayers().toArray();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getColumnIndex() == 0) {
                    ILayer layer = (ILayer)cell.getElement();
                    cell.setText(layer.getName());
                } else {
                    cell.setText("");
                }
            }
        });
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                ILayer layer = (ILayer)element;
                boolean isActive = layers.isActive(layer);
                return isActive;
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.viewer.setInput((Object)this);
        for (ILayer layer : layers.getVisibleLayers()) {
            this.viewer.setSubtreeChecked((Object)layer, true);
        }
        this.composite.layout();
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    private void removeSelectedLayers() {
        TreeItem[] items = this.viewer.getTree().getSelection();
        if (items.length == 0) {
            return;
        }
        Object[] all = this.viewer.getTree().getItems();
        int firstIndex = Arrays.indexOf((Object[])all, (Object)items[0]);
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            int index = Arrays.indexOf((Object[])all, (Object)item);
            all[index] = null;
            ILayer layer = (ILayer)item.getData();
            this.layers.removeLayer(layer);
            ++n2;
        }
        int selectIndex = firstIndex - 1;
        if (firstIndex == 0) {
            int i = firstIndex;
            while (i < all.length) {
                if (all[i] != null) {
                    selectIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (selectIndex >= 0) {
            this.viewer.getTree().select((TreeItem)all[selectIndex]);
        }
        this.context.getThreadAccess().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DiagramLayersPage.this.context.isDisposed()) {
                    return;
                }
                DiagramLayersPage.this.context.getContentContext().setDirty();
            }
        });
    }

    private boolean startEditing(final ILayer layer, final TreeItem item) {
        String initialText = layer.getName();
        final Composite composite = new Composite((Composite)this.viewer.getTree(), 0);
        final Text text = new Text(composite, 2048);
        composite.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Rectangle rect = composite.getClientArea();
                text.setBounds(rect.x + 0, rect.y + 0, rect.width - 0, rect.height - 0);
            }
        });
        Listener textListener = new Listener(){

            public void handleEvent(Event e) {
                block0 : switch (e.type) {
                    case 16: {
                        if (layer instanceof IEditableLayer) {
                            IEditableLayer l = (IEditableLayer)layer;
                            String name = DiagramLayersPage.findFreshName((ILayers)DiagramLayersPage.this.layers, text.getText());
                            l.setName(name);
                            DiagramLayersPage.this.viewer.refresh();
                        }
                        composite.dispose();
                        break;
                    }
                    case 24: {
                        break;
                    }
                    case 25: {
                        String newText = text.getText();
                        String leftText = newText.substring(0, e.start);
                        String rightText = newText.substring(e.end, newText.length());
                        GC gc = new GC((Drawable)text);
                        Point size = gc.textExtent(leftText + e.text + rightText);
                        gc.dispose();
                        size = text.computeSize(size.x, -1);
                        DiagramLayersPage.this.editor.horizontalAlignment = 16384;
                        Rectangle itemRect = item.getBounds(0);
                        Rectangle rect = DiagramLayersPage.this.viewer.getTree().getClientArea();
                        DiagramLayersPage.this.editor.minimumWidth = Math.max(size.x, itemRect.width) + 0;
                        int left = itemRect.x;
                        int right = rect.x + rect.width;
                        DiagramLayersPage.this.editor.minimumWidth = Math.min(DiagramLayersPage.this.editor.minimumWidth, right - left);
                        DiagramLayersPage.this.editor.minimumHeight = size.y + 0;
                        DiagramLayersPage.this.editor.layout();
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                if (layer instanceof IEditableLayer) {
                                    IEditableLayer l = (IEditableLayer)layer;
                                    String name = DiagramLayersPage.findFreshName((ILayers)DiagramLayersPage.this.layers, text.getText());
                                    l.setName(name);
                                    DiagramLayersPage.this.viewer.refresh();
                                }
                            }
                            case 2: {
                                composite.dispose();
                                e.doit = false;
                                break block0;
                            }
                        }
                    }
                }
            }
        };
        text.addListener(16, textListener);
        text.addListener(31, textListener);
        text.addListener(25, textListener);
        text.addListener(24, textListener);
        this.editor.setEditor((Control)composite, item, 0);
        text.setText(initialText);
        text.selectAll();
        text.setFocus();
        return true;
    }

    static enum Attribute {
        Visible,
        Focusable;

    }

    static enum Tristate {
        True,
        False,
        Both;


        static Tristate to(Boolean b) {
            return b == null ? null : (b != false ? True : False);
        }

        boolean toBoolean() {
            switch (this) {
                case Both: {
                    throw new IllegalStateException("cannot convert Tristate Both to boolean");
                }
                case False: {
                    return false;
                }
                case True: {
                    return true;
                }
            }
            return false;
        }

        Tristate toggle() {
            switch (this) {
                case False: 
                case Both: {
                    return True;
                }
                case True: {
                    return False;
                }
            }
            return False;
        }

        Tristate merge(Tristate state) {
            if (state == null) {
                return this;
            }
            switch (this) {
                case Both: {
                    return Both;
                }
                case False: {
                    switch (state) {
                        case False: {
                            return False;
                        }
                        case True: 
                        case Both: {
                            return Both;
                        }
                    }
                }
                case True: {
                    switch (state) {
                        case True: {
                            return True;
                        }
                        case False: 
                        case Both: {
                            return Both;
                        }
                    }
                }
            }
            return this;
        }
    }
}

