/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.componentTypeEditor.SCLQueryEditor;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Failure;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.logging.TimeLogger;

public class SCLQueryEditorDocumentProvider
extends AbstractDocumentProvider {
    Resource resource;
    String currentText;
    boolean errorHappened;
    AnnotationModel annotationModel = new AnnotationModel();
    SCLQueryEditor editor;
    private UpdateListener listener = new UpdateListener(){

        public void notifyAboutUpdate() {
            SCLQueryEditorDocumentProvider.this.updateAnnotations();
        }
    };
    boolean annotationsInitialized = false;

    public SCLQueryEditorDocumentProvider(SCLQueryEditor editor) {
        this.editor = editor;
    }

    private boolean isType(ReadGraph graph) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        return graph.isInstanceOf(this.resource, MOD.SCLQueryType);
    }

    protected IDocument createDocument(Object element) throws CoreException {
        ResourceEditorInput input = (ResourceEditorInput)element;
        this.resource = input.getResource();
        try {
            return (IDocument)Simantics.getSession().syncRequest((Read)new UniqueRead<Document>(){

                public Document perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    if (SCLQueryEditorDocumentProvider.this.isType(graph)) {
                        Collection assertions = graph.getAssertedObjects(SCLQueryEditorDocumentProvider.this.resource, MOD.SCLQuery_values);
                        if (assertions.size() != 1) {
                            throw new DatabaseException("No query text assertion defined in Query Type");
                        }
                        Resource value = (Resource)assertions.iterator().next();
                        SCLQueryEditorDocumentProvider.this.currentText = (String)graph.getRelatedValue(value, L0.SCLValue_expression, (Binding)Bindings.STRING);
                        SCLQueryEditorDocumentProvider.this.errorHappened = false;
                        return new Document(SCLQueryEditorDocumentProvider.this.currentText != null ? SCLQueryEditorDocumentProvider.this.currentText : "");
                    }
                    Resource value = graph.getSingleObject(SCLQueryEditorDocumentProvider.this.resource, MOD.SCLQuery_values);
                    SCLQueryEditorDocumentProvider.this.currentText = (String)graph.getRelatedValue(value, L0.SCLValue_expression, (Binding)Bindings.STRING);
                    SCLQueryEditorDocumentProvider.this.errorHappened = false;
                    return new Document(SCLQueryEditorDocumentProvider.this.currentText != null ? SCLQueryEditorDocumentProvider.this.currentText : "");
                }
            });
        }
        catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.errorHappened = false;
            return new Document(sw.toString());
        }
    }

    private void updateAnnotations() {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                String moduleName = graph.getURI(SCLQueryEditorDocumentProvider.this.resource);
                SCLContext context = SCLContext.getCurrent();
                context.put((Object)"graph", (Object)graph);
                Failable result = SCLOsgi.MODULE_REPOSITORY.getModule(moduleName, SCLQueryEditorDocumentProvider.this.listener);
                if (result instanceof Failure) {
                    Failure failure = (Failure)result;
                    SCLQueryEditorDocumentProvider.this.setAnnotations(Arrays.asList(failure.errors));
                } else {
                    SCLQueryEditorDocumentProvider.this.setAnnotations(Collections.emptyList());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnnotations(List<CompilationError> errors) {
        Object object = this.annotationModel.getLockObject();
        synchronized (object) {
            this.annotationModel.removeAllAnnotations();
            for (CompilationError error : errors) {
                Annotation annotation = new Annotation("org.eclipse.ui.workbench.texteditor.error", true, error.description);
                int begin = Locations.beginOf((long)error.location);
                int end = Locations.endOf((long)error.location);
                Position position = new Position(begin, end - begin);
                this.annotationModel.addAnnotation(annotation, position);
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (!this.annotationsInitialized) {
            this.updateAnnotations();
            this.annotationsInitialized = true;
        }
        return this.annotationModel;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        TimeLogger.resetTimeAndLog((String)"SCLModuleEditorDocumentProvider.doSaveDocument");
        this.currentText = document.get();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            private Resource getValue(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                if (SCLQueryEditorDocumentProvider.this.isType((ReadGraph)graph)) {
                    Collection assertions = graph.getAssertedObjects(SCLQueryEditorDocumentProvider.this.resource, MOD.SCLQuery_values);
                    if (assertions.size() > 1) {
                        throw new DatabaseException("Invalid query text assertions in Query Type");
                    }
                    if (assertions.size() == 1) {
                        return (Resource)assertions.iterator().next();
                    }
                    Resource value = graph.newResource();
                    graph.claim(value, L0.InstanceOf, MOD.SCLQuery_Value);
                    Layer0Utils.assert_((WriteGraph)graph, (Resource)SCLQueryEditorDocumentProvider.this.resource, (Resource)MOD.SCLQuery_values, (Resource)value);
                    return value;
                }
                Statement stm = graph.getSingleStatement(SCLQueryEditorDocumentProvider.this.resource, MOD.SCLQuery_values);
                if (stm.isAsserted(SCLQueryEditorDocumentProvider.this.resource)) {
                    Resource value = graph.newResource();
                    graph.claim(value, L0.InstanceOf, MOD.SCLQuery_Value);
                    graph.claim(SCLQueryEditorDocumentProvider.this.resource, MOD.SCLQuery_values, value);
                    return value;
                }
                return stm.getObject();
            }

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                Resource value = this.getValue(graph);
                graph.claimLiteral(value, L0.SCLValue_expression, (Object)SCLQueryEditorDocumentProvider.this.currentText, (Binding)Bindings.STRING);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Saved SCL Query " + String.valueOf(graph.getRelatedValue2(SCLQueryEditorDocumentProvider.this.resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING))));
            }
        });
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        return !this.errorHappened;
    }

    public boolean isReadOnly(Object element) {
        return this.errorHappened;
    }
}

