/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.scl.scriptEditor;

import org.simantics.Simantics;
import org.simantics.db.exception.DatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
class SCLScriptSource {

    private static final Logger LOGGER = LoggerFactory.getLogger(SCLScriptSource.class);

    private String scriptURI;
    private String scriptText;

    public SCLScriptSource(String scriptURI, String scriptText) {
        this.scriptURI = scriptURI;
        this.scriptText = scriptText;
    }

    public void update(String newSourceText) {
        try {
            Simantics.getSession().syncRequest(new WriteSCLScriptDefinition(scriptURI, newSourceText));
        } catch (DatabaseException e) {
            LOGGER.error("Failed to write SCL script source from " + scriptURI, e);
        }
    }

    public boolean isUpdateable() {
        return true;
    }

    public String getSourceText() {
        return scriptText;
    }

    public String getScriptURI() {
        return scriptURI;
    }

}