package org.simantics.modeling.ui.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.diagram.connection.rendering.ConnectionCrossings;
import org.simantics.modeling.ui.Activator;
import org.simantics.ui.workbench.preferences.NumberFieldEditor;

public class DiagramConnectionPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

    public DiagramConnectionPreferencePage() {
        super(GRID);
    }
    
    @Override
    public void init(IWorkbench workbench) {
    }
    
    @Override
    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.PLUGIN_ID);
    }

    @Override
    protected void createFieldEditors() {
        Group group = new Group(getFieldEditorParent(), SWT.NONE);
        group.setText("Connection crossing");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo(group);
        
        String[][] gapStyles = new String[ConnectionCrossings.Type.values().length][];
        for (int i = 0; i < ConnectionCrossings.Type.values().length; i++) {
            ConnectionCrossings.Type t = ConnectionCrossings.Type.values()[i];
            gapStyles[i] = new String[] {t.name(),t.toString()};
        }
        
        RadioGroupFieldEditor typeField = new RadioGroupFieldEditor(DiagramPreferences.P_DEFAULT_CONNECTION_CROSSING_STYLE, "Crossing style", 1, gapStyles, group);
        addField(typeField);
        
        NumberFieldEditor widthField = new NumberFieldEditor(DiagramPreferences.P_DEFAULT_CONNECTION_CROSSING_WIDTH, "Width (mm)", group);
        widthField.setValidRange(0, 1e2);
        addField(widthField);
    }
    

}
