/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.contributions;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.comparators.LexicalComparatorFactory;
import org.simantics.browsing.ui.common.contributor.ComparableContributorImpl;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.db.Resource;

/**
 * A common lexically sorting contributor for {@link Resource} instances.
 * 
 * @author Tuukka Lehtonen
 */
public class LexicalComparableContributor extends ComparableContributorImpl<Object> {

    @Override
    public ComparableContextFactory getFactory() {
        return new LexicalComparatorFactory(ColumnKeys.SINGLE);
    }

}
