/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.contributions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.ui.modelBrowser.nodes.AbstractNode;

/**
 * @author Tuukka Lehtonen
 */
public class DependenciesViewContributor implements RelationViewContributor {

    public Collection<?> getContribution(ReadGraph graph, Collection<Map<String, Object>> indexedResults) throws DatabaseException {
        ArrayList<Object> result = new ArrayList<Object>();

        for(Map<String, Object> entry : indexedResults) {
            Object resource = entry.get("Resource");
            if (resource != null) {
                AbstractNode node = graph.syncRequest(Queries.adapt((Resource) resource, AbstractNode.class, true));
                if (node != null) {
                    result.add(node);
                } else {
                    result.add(resource);
                }
            } else {
                Object name = entry.get("Name");
                if (name != null) {
                    result.add(name);
                } else {
                    StringBuilder b = new StringBuilder();
                    for (Map.Entry<String, Object> e : entry.entrySet()) {
                        b.append(e.getValue().toString());
                    }
                    result.add(b.toString());
                }
            }
        }

        return result;
    }
}
