/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.tools;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.elements.ElementTransforms;
import org.simantics.diagram.elements.ElementTransforms.SIDE;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.modeling.ui.diagramEditor.DiagramViewer;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * Diagramming alignment tools
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 */
public class AlignTools implements DiagramTools {

    private Resource selection[] = new Resource[0];

    Button alignLeft;
    Button alignVertButton;
    Button alignRight;
    Button alignTop;
    Button alignHorizButton;
    Button alignBottom;
    Button distLeft;
    Button distVert;
    Button distRight;
    Button distVertBetween;
    Button distTop;
    Button distHoriz;
    Button distBottom;
    Button distHorizBetween;

    Button rotateCW;
    Button rotateCCW;
    Button flipX;
    Button flipY;



    @Override
    public String getName() {
        return "Align";
    }


    @Override
    public void createContols(Composite parent, FormToolkit toolkit, LocalResourceManager resourceManager) {
    	parent.setLayout(GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).margins(0, 0).spacing(1,1).create());
		
		Composite alignComposite = new Composite(parent, SWT.NONE);
		Composite distributeComposite = new Composite(parent, SWT.NONE);
		Composite rotateComposite = new Composite(parent, SWT.NONE);
		alignComposite.setLayout(GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).margins(0, 2).spacing(0, 0).create());
		distributeComposite.setLayout(GridLayoutFactory.fillDefaults().numColumns(4).equalWidth(true).margins(0, 2).spacing(0, 0).create());
		rotateComposite.setLayout(GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).margins(0, 2).spacing(0, 0).create());

        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(alignComposite);
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(distributeComposite);
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(rotateComposite);

        alignLeft = toolkit.createButton(alignComposite, "", SWT.PUSH);
        //alignLeft.setText("Left");
        alignLeft.setToolTipText("Align Left Edges");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(alignLeft);

        alignVertButton = toolkit.createButton(alignComposite, "", SWT.PUSH);
        //alignVertButton.setText("Middle");
        alignVertButton.setToolTipText("Center on Vertical Axis");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(alignVertButton);

        alignRight = toolkit.createButton(alignComposite, "", SWT.PUSH);
        //alignRight.setText("Right");
        alignRight.setToolTipText("Align Right Edges");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(alignRight);

        alignTop = toolkit.createButton(alignComposite, "", SWT.PUSH);
        //alignTop.setText("Top");
        alignTop.setToolTipText("Align Top Edges");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(alignTop);

        alignHorizButton = toolkit.createButton(alignComposite, "", SWT.PUSH);
        //alignHorizButton.setText("Middle");
        alignHorizButton.setToolTipText("Center on Horizontal Axis");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(alignHorizButton);

        alignBottom = toolkit.createButton(alignComposite, "", SWT.PUSH);
        //alignBottom.setText("Bottom");
        alignBottom.setToolTipText("Align Bottom Edges");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(alignBottom);

        distLeft = toolkit.createButton(distributeComposite, "", SWT.PUSH);
        //distLeft.setText("Left");
        distLeft.setToolTipText("Distribute Left Edges Equidistantly");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(distLeft);

        distVert = toolkit.createButton(distributeComposite, "", SWT.PUSH);
        //distVert.setText("Middle");
        distVert.setToolTipText("Distribute Centers Equidistantly Horizontally");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(distVert);

        distRight = toolkit.createButton(distributeComposite, "", SWT.PUSH);
        //distRight.setText("Right");
        distRight.setToolTipText("Distribute Right Edges Equidistantly");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(distRight);

        distVertBetween = toolkit.createButton(distributeComposite, "", SWT.PUSH);
        //distVertBetween.setText("Between");
        distVertBetween.setToolTipText("Make Horizontal Gaps Between Objects Equal");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(distVertBetween);

        distTop = toolkit.createButton(distributeComposite, "", SWT.PUSH);
        //distTop.setText("Top");
        distTop.setToolTipText("Distribute Top Edges Equidistantly");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(distTop);

        distHoriz = toolkit.createButton(distributeComposite, "", SWT.PUSH);
        //distHoriz.setText("Middle");
        distHoriz.setToolTipText("Distribute Centers Equidistantly Vertically");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(distHoriz);

        distBottom = toolkit.createButton(distributeComposite, "", SWT.PUSH);
        //distBottom.setText("Bottom");
        distBottom.setToolTipText("Distribute Bottom Edges Equidistantly");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(distBottom);

        distHorizBetween = toolkit.createButton(distributeComposite, "", SWT.PUSH);
        //distHorizBetween.setText("Between");
        distHorizBetween.setToolTipText("Make Vertical Gaps Between Objects Equal");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(distHorizBetween);

        rotateCCW = toolkit.createButton(rotateComposite, "", SWT.PUSH);
        //rotateCCW.setText("rotate left");
        rotateCCW.setToolTipText("Rotate Counterclockwise");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(rotateCCW);

        rotateCW = toolkit.createButton(rotateComposite, "", SWT.PUSH);
        //rotateCW.setText("rotate right");
        rotateCW.setToolTipText("Rotate Clockwise");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(rotateCW);

        flipX = toolkit.createButton(rotateComposite, "", SWT.PUSH);
        //flipX.setText("flip");
        flipX.setToolTipText("Flip About Horizontal Axis");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(flipX);

        flipY = toolkit.createButton(rotateComposite, "", SWT.PUSH);
        //flipY.setText("mirror");
        flipY.setToolTipText("Flip About Vertical Axis");
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).applyTo(flipY);

        alignVertButton.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align(getDiagram(), getSelected(), SIDE.VERT);
            }
        });

        alignHorizButton.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align(getDiagram(), getSelected(),SIDE.HORIZ);
            }
        });

        alignLeft.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align(getDiagram(), getSelected(),SIDE.LEFT);
            }
        });

        alignRight.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align(getDiagram(), getSelected(),SIDE.RIGHT);
            }
        });

        alignTop.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align(getDiagram(), getSelected(),SIDE.TOP);
            }
        });

        alignBottom.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align(getDiagram(), getSelected(), SIDE.BOTTOM);
            }
        });

        distLeft.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist(getDiagram(), getSelected(), SIDE.LEFT);
            }
        });

        distVert.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist(getDiagram(), getSelected(), SIDE.VERT);
            }
        });

        distRight.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist(getDiagram(), getSelected(), SIDE.RIGHT);
            }
        });

        distVertBetween.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist(getDiagram(), getSelected(), SIDE.VERT_BTW);
            }
        });

        distTop.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist(getDiagram(), getSelected(), SIDE.TOP);
            }
        });

        distHoriz.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist(getDiagram(), getSelected(), SIDE.HORIZ);
            }
        });

        distBottom.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist(getDiagram(), getSelected(), SIDE.BOTTOM);
            }
        });

        distHorizBetween.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist(getDiagram(), getSelected(), SIDE.HORIZ_BTW);
            }
        });

        rotateCW.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.rotate(getDiagram(), getSelected(), true);
            }
        });

        rotateCCW.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.rotate(getDiagram(), getSelected(), false);
            }
        });

        flipX.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.flip(getDiagram(), getSelected(),true);
            }
        });

        flipY.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.flip(getDiagram(), getSelected(),false);
            }
        });

        alignLeft.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/align_left.png"))));
        alignVertButton.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/align_center.png"))));
        alignRight.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/align_right.png"))));
        alignTop.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/align_top.png"))));
        alignHorizButton.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/align_middle.png"))));
        alignBottom.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/align_bottom.png"))));

        distLeft.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/dist_left.png"))));
        distVert.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/dist_center.png"))));
        distRight.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/dist_right.png"))));
        distVertBetween.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/dist_horiz.png"))));
        distTop.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/dist_top.png"))));
        distHoriz.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/dist_middle.png"))));
        distBottom.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/dist_bottom.png"))));
        distHorizBetween.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/dist_vert.png"))));

        rotateCCW.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/rotate_left.png"))));
        rotateCW.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/rotate_right.png"))));
        flipX.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/flip_x.png"))));
        flipY.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/flip_y.png"))));

        updateUI();
    }
    
    private static IDiagram getDiagram() {

        IWorkbenchPart ap = WorkbenchUtils.getActiveEditor();
        if (ap instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor) ap;
            DiagramViewer viewer = editor.getViewer();
            return viewer.getAdapter(IDiagram.class);
        }
        
        return null;

    }

    @Override
    public void setSelection(ISelection s) {
        this.selection = ResourceAdaptionUtils.toResources(s);
        try {
            Simantics.getSession().syncRequest(new ReadRequest() {

                @Override
                public void run(ReadGraph graph) throws DatabaseException {
                    DiagramResource dr = DiagramResource.getInstance(graph);
                    List<Resource> sel = new ArrayList<Resource>();
                    for (Resource r : selection) {
                        if(graph.isInstanceOf(r, dr.Element) && !graph.isInstanceOf(r, dr.Connection) /*&& !graph.isInstanceOf(r, dr.Monitor)*/) {
                            sel.add(r);
                        }
                    }
                    selection = sel.toArray(new Resource[sel.size()]);

                }
            });

            updateUI();
        } catch (DatabaseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    private void updateUI() {
        boolean showAlign = selection.length >= 2;
        boolean showDist = selection.length >= 3;
        boolean showRotate = selection.length >= 1;
        alignBottom.setEnabled(showAlign);
        alignHorizButton.setEnabled(showAlign);
        alignLeft.setEnabled(showAlign);
        alignRight.setEnabled(showAlign);
        alignTop.setEnabled(showAlign);
        alignVertButton.setEnabled(showAlign);

        distBottom.setEnabled(showDist);
        distHoriz.setEnabled(showDist);
        distHorizBetween.setEnabled(showDist);
        distLeft.setEnabled(showDist);
        distRight.setEnabled(showDist);
        distTop.setEnabled(showDist);
        distVert.setEnabled(showDist);
        distVertBetween.setEnabled(showDist);

        rotateCCW.setEnabled(showRotate);
        rotateCW.setEnabled(showRotate);
        flipX.setEnabled(showRotate);
        flipY.setEnabled(showRotate);
    }

    @Override
    public void dispose() {

    }

    private Resource[] getSelected() {
        return selection;
    }

}
