package org.simantics.modeling.ui.componentTypeEditor;

import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

public class PGraphSourceViewerConfigurationNew extends SourceViewerConfiguration {

    public static final char[] CONTENT_ASSIST_AUTO_CHARS = new char[] { '.' };
    Device device;

    ISharedTextColors sharedTextColors;
    Font font;
    Font boldFont;

    public PGraphSourceViewerConfigurationNew(Device device, ISharedTextColors sharedTextColors) {
        this.device = device;
        this.sharedTextColors = sharedTextColors;

        this.font = new Font(device, "Courier New", 10, SWT.NORMAL); //$NON-NLS-1$
        this.boldFont = new Font(device, "Courier New", 10, SWT.BOLD); //$NON-NLS-1$
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[] {
            IDocument.DEFAULT_CONTENT_TYPE
        };
    }
    
    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(getSclTokenScanner());
        
        reconciler.setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);
        reconciler.setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
        
        return reconciler;
    }
    
    ITokenScanner getSclTokenScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();

        Token defaultToken = new Token(
                new TextAttribute(
                        sharedTextColors.getColor(new RGB(0, 0, 0)),
                        null,
                        0,
                        font
                ));
        Token string = new Token(new TextAttribute(
                sharedTextColors.getColor(new RGB(42, 0, 255)),
                null,
                0,
                font
                ));
        Token reserved = new Token(
                new TextAttribute(
                        sharedTextColors.getColor(new RGB(127, 0, 85)),
                        null,
                        SWT.BOLD,
                        boldFont
                ));
        Token comment = new Token(new TextAttribute(
                sharedTextColors.getColor(new RGB(63, 127, 95)),
                null,
                0,
                font
                ));

        WordRule reservedWord = new WordRule(new IWordDetector() {          
            @Override
            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }
            
            @Override
            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c) || c=='.';
            }
        });

        reservedWord.addWord("if", reserved); //$NON-NLS-1$
        reservedWord.addWord("then", reserved); //$NON-NLS-1$
        reservedWord.addWord("else", reserved); //$NON-NLS-1$
        reservedWord.addWord("match", reserved); //$NON-NLS-1$
        reservedWord.addWord("with", reserved); //$NON-NLS-1$
        reservedWord.addWord("data", reserved); //$NON-NLS-1$
        reservedWord.addWord("type", reserved); //$NON-NLS-1$
        reservedWord.addWord("class", reserved); //$NON-NLS-1$
        
        IRule[] rules = new IRule[] {
            //new MultiLineRule("\"\"\"", "\"\"\"", string),
            new PatternRule("\"", "\"", string, '\\', true), //$NON-NLS-1$ //$NON-NLS-2$
            new MultiLineRule("/*", "*/", comment), //$NON-NLS-1$ //$NON-NLS-2$
            new PatternRule("//", null, comment, '\0', true), //$NON-NLS-1$
            reservedWord
        };
        scanner.setRules(rules);
        scanner.setDefaultReturnToken(defaultToken);
        
        return scanner;     
    }
    
    @Override
    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new DefaultTextHover(sourceViewer);
    }
    
    @Override
    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }

    public void dispose() {
        font.dispose();
        boldFont.dispose();
    }

}
