/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.function;

import java.util.Vector;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.image2.ontology.ImageResource;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class LinkSVGImage {
    public static void linkSVGImage(WriteGraph graph, final Resource parent, final Resource child) {
        final String[] uri = new String[1];
        final String[] msg = new String[1];
        try {
            graph.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph g) throws DatabaseException {
                    if (parent == null || child == null) {
                        msg[0] = "Creation of image reference failed. Activate an experiment and try to copy and paste an image again.";
                        return;
                    }
                    ImageResource IMG = ImageResource.getInstance((ReadGraph)g);
                    if (!g.isInstanceOf(child, IMG.SvgImage)) {
                        msg[0] = "Creation of image reference failed. Activate an experiment and try to copy and paste an image again.";
                        return;
                    }
                    Variable parentV = Variables.getVariable((ReadGraph)g, (Resource)parent);
                    if (parentV == null) {
                        msg[0] = "Creation of image reference failed. Activate an experiment and try to copy and paste an image again.";
                        return;
                    }
                    Vector<Variable> grandOfParent = new Vector<Variable>();
                    Variable tmp = parentV;
                    do {
                        grandOfParent.add(0, tmp);
                    } while ((tmp = tmp.getParent(g)) != null);
                    Variable childV = Variables.getVariable((ReadGraph)g, (Resource)child);
                    String childUri = null;
                    if (childV == null) {
                        msg[0] = "Creation of image reference failed. Activate an experiment and try to copy and paste an image again.";
                        return;
                    }
                    Vector<Variable> grandOfChild = new Vector<Variable>();
                    tmp = childV;
                    do {
                        grandOfChild.add(0, tmp);
                    } while ((tmp = tmp.getParent(g)) != null);
                    int k = -1;
                    int maxLen = grandOfChild.size() < grandOfParent.size() ? grandOfChild.size() : grandOfParent.size();
                    int i = 0;
                    while (i < maxLen) {
                        if (!((Variable)grandOfChild.get(i)).equals(grandOfParent.get(i))) break;
                        ++k;
                        ++i;
                    }
                    if (k == -1) {
                        msg[0] = "Creation of image reference failed. Activate an experiment and try to copy and paste an image again.";
                        return;
                    }
                    SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)g);
                    ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)g);
                    Template2dResource TEPLATE2D = Template2dResource.getInstance((ReadGraph)g);
                    Resource root = g.getRootLibrary();
                    Resource type = null;
                    String predefined = null;
                    Resource res = null;
                    while (k >= 0) {
                        tmp = (Variable)grandOfChild.get(k);
                        res = tmp.getRepresents(g);
                        if (res.equals(root)) {
                            predefined = "root";
                            break;
                        }
                        type = g.getPossibleType(res, SIMU.Model);
                        if (type != null) {
                            predefined = "model";
                            break;
                        }
                        type = g.getPossibleType(res, PROJ.Project);
                        if (type != null) {
                            predefined = "project";
                            break;
                        }
                        type = g.getPossibleType(res, TEPLATE2D.DrawingTemplate);
                        if (type != null) {
                            predefined = "template";
                            break;
                        }
                        --k;
                    }
                    if (predefined == null) {
                        msg[0] = "Creation of image reference failed. Activate an experiment and try to copy and paste an image again.";
                        return;
                    }
                    Variable resV = Variables.getVariable((ReadGraph)g, res);
                    String resUri = resV.getURI(g);
                    childUri = childV.getURI(g);
                    Resource childModel = Variables.getModel((ReadGraph)g, (Variable)childV);
                    Resource parentModel = Variables.getModel((ReadGraph)g, (Variable)parentV);
                    if (childModel == null || parentModel == null) {
                        msg[0] = "Creation of image reference failed. Activate an experiment and try to copy and paste an image again.";
                        return;
                    }
                    if (!parentModel.equals(childModel)) {
                        msg[0] = "Creation of image reference failed. Activate an experiment and try to copy and paste an image again.";
                        return;
                    }
                    if (childUri.startsWith(resUri)) {
                        uri[0] = childUri.substring(resUri.length());
                        uri[0] = "pre:/" + predefined + uri[0];
                    }
                }
            });
            graph.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph g) throws DatabaseException {
                    if (uri == null || parent == null) {
                        msg[0] = "Creation of image reference failed. Activate an experiment and try to copy and paste an image again.";
                        return;
                    }
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
                    Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)g);
                    Resource var = g.getPossibleObject(parent, DIA.Scenegraph_SVGImage_document);
                    if (var == null) {
                        msg[0] = "Creation of image reference failed. Only SVG images are supported for now.";
                        return;
                    }
                    g.claimLiteral(var, TEMPLATE2D.Profiles_VariableReference_path, (Object)(uri[0] + "#data"), (Binding)Bindings.STRING);
                }
            });
            if (msg[0] != null) {
                ShowMessage.showWarning((String)"Warning", (String)msg[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

