/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.diagram.dialogs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.dialogs.ShowError;

public class BindToIOTableDialog extends Dialog {
	private Map<String,Resource> entries = new HashMap<String,Resource>();
	private Session session = null;
	private Combo combo = null;
	private Resource flag = null;
	private String currentAlignment = null;
	private int currentIndex = -1;
	private Text indexTxT = null;

	public BindToIOTableDialog(Shell parentShell) {
		super(parentShell);
		// TODO Auto-generated constructor stub
	}
	
	public boolean init(ExecutionEvent event){
		ISelection selection = HandlerUtil.getCurrentSelection(event);
        flag = ResourceAdaptionUtils.toSingleResource(selection);
        if (flag == null)
            return false;

        session = Simantics.getSession();
        if (session == null)
        	return false;
        try {
			session.syncRequest(new ReadRequest(){
				@Override
				public void run(ReadGraph g) throws DatabaseException {
			        entries.put("", null);
					DiagramResource DIA = DiagramResource.getInstance(g);
					Layer0 L0 = Layer0.getInstance(g);
                    Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);

					Resource parent = OrderedSetUtils.getSingleOwnerList(g, flag, DiagramResource.getInstance(g).Composite);
					//Resource parent = g.getPossibleObject(flag, L0.PartOf);
					Resource diagram = null;
					Resource template = null;
					
					if (parent != null && g.isInstanceOf(parent, DIA.Diagram)){
						diagram = parent;
//				        diagram = g.getPossibleObject(parent, DIA.RuntimeDiagram_HasConfiguration);
//				        if(diagram != null)
				        	template = g.getPossibleObject(diagram, TEMPLATE2D.HasDrawingTemplate);
					}
		        	if(template == null)
		        		return;
		        	
		        	Collection<Resource> children = g.getObjects(template, L0.ConsistsOf);
			        for (Resource child:children){
			        	if (!g.isInstanceOf(child, TEMPLATE2D.FlagTable))
			        		continue;
			        	String name = g.getPossibleRelatedValue2(child, L0.HasName, Bindings.STRING);
			        	if (name != null)
			        		entries.put(name, child);
			        }

			        currentAlignment = g.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableBinding, Bindings.STRING);
			        currentIndex = g.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableRowIndex, Bindings.INTEGER);
				}});
		} catch (DatabaseException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		Composite c = (Composite) super.createDialogArea(parent);
		
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(2).applyTo(c);
        GridDataFactory gd1 = GridDataFactory.fillDefaults().span(1, 1);

        // 1st line
        Label label = new Label(c, 0);
        label.setText("IO table:");
        gd1.applyTo(label);
        
        combo = new Combo(c, 0);
        int i = 0;
        int selectedIndex = -1;
        
        for (Map.Entry<String,Resource> entry:entries.entrySet()){
        	combo.add(entry.getKey());
        	if (currentAlignment != null && entry.getKey().equals(currentAlignment))
        		selectedIndex = i;
        	i++;	
        }
        if (selectedIndex != -1)
        	combo.select(selectedIndex);
        else
        	combo.clearSelection();
        gd1.applyTo(combo);
        
        // 2nd line
        label = new Label(c, 0);
        label.setText("Row index:");
        gd1.applyTo(label);

        indexTxT = new Text(c, SWT.BORDER);
        indexTxT.setText("" + currentIndex);
        gd1.applyTo(indexTxT);
        
		return c;
	}
	@Override
	protected void okPressed() {
        try {
        	currentIndex = -1;
        	try {
        		currentIndex = Integer.parseInt(indexTxT.getText());
        	} catch (NumberFormatException e){}
        	final Integer index = currentIndex;
        	
        	int selectedAlignmentIndex = combo.getSelectionIndex();
        	String selectedAligmentTxt = null;
        	if (selectedAlignmentIndex != -1)
        		selectedAligmentTxt = combo.getItem(selectedAlignmentIndex);
        	//String oldAlignment = currentAlignment; 
        	if (selectedAligmentTxt != null)
        		currentAlignment = selectedAligmentTxt;//entries.get(selectedAligmentTxt);
        	if (currentAlignment != null){
        		if (currentAlignment.length() > 0){
        			session.syncRequest(new WriteRequest(){
        				@Override
        				public void perform(WriteGraph g) throws DatabaseException {
        					DiagramResource DIA = DiagramResource.getInstance(g);
        					g.claimLiteral(flag, DIA.Flag_HasIOTableBinding, currentAlignment, Bindings.STRING);
        			        g.claimLiteral(flag, DIA.Flag_HasIOTableRowIndex, index, Bindings.INTEGER);

        				}});
        		} else {
        			session.syncRequest(new WriteRequest(){
        				@Override
        				public void perform(WriteGraph g) throws DatabaseException {
        					DiagramResource DIA = DiagramResource.getInstance(g);
        					g.claimLiteral(flag, DIA.Flag_HasIOTableBinding, "", Bindings.STRING);
        			        g.claimLiteral(flag, DIA.Flag_HasIOTableRowIndex, -1, Bindings.INTEGER);
        				}});
        		}
        	}
//			session.syncRequest(new WriteRequest(){
//				@Override
//				public void perform(WriteGraph g) throws DatabaseException {
//					DiagramResource DIA = DiagramResource.getInstance(g);
//			        g.claimLiteral(flag, DIA.Flag_HasIOTableRowIndex, index, Bindings.INTEGER);
//				}});
        } catch (DatabaseException e) {
        	ShowError.showError("Error", "Unexpected database error.", e);
        	return;
        }
        catch (NumberFormatException e) {
        	ShowError.showError("Error", "Index has to be a number.", e);
        	return;
        }
        super.okPressed();
	}

	@Override
    protected int getShellStyle() {
        return SWT.RESIZE | SWT.TITLE | SWT.CLOSE | SWT.BORDER;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select IO Table Location");
    }
}
