/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.actions;

import java.util.Arrays;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.ontology.ScenegraphResources;

public class NewFlagTypeVisualFilter  implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource parent = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                Simantics.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                    	createNewFilter(g, parent);
                    }
                });
            }
        };
    }
    
    public static Resource createNewFilter(WriteGraph g, Resource parent) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);
        ScenegraphResources SG = ScenegraphResources.getInstance(g);

        Resource newRes = g.newResource();
        g.claim(newRes, L0.InstanceOf, null, TEMPLATE2D.FlagTypeVisual_Filter);
        g.claim(newRes, L0.InstanceOf, null, TEMPLATE2D.FlagTypeVisual_FilterUI);
        String name = NameUtils.findFreshName(g, "Filter", parent, L0.ConsistsOf);
        g.addLiteral(newRes, L0.HasName, L0.NameOf, L0.String, name, Bindings.STRING);
        g.claim(newRes, L0.PartOf, parent);

        Resource list = g.getPossibleObject(parent, SG.Node_children);
        if (list != null)
            ListUtils.insertBack(g, list, Arrays.asList(newRes));
        return newRes;
    }
}
