package org.simantics.modeling.utils;

import gnu.trove.map.hash.THashMap;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.structural.stubs.StructuralResource2;

public class JoinMap extends FunctionImpl1<Object, Resource> {

    THashMap<Object,Resource> map = new THashMap<Object,Resource>(); 
    
    @Override
    public Resource apply(Object key) {
        Resource join = map.get(key);
        if(join == null) {
            try {
                WriteGraph g = (WriteGraph)SCLContext.getCurrent().get("graph");
                Layer0 L0 = Layer0.getInstance(g);
                StructuralResource2 STR = StructuralResource2.getInstance(g);
                join = g.newResource();
                g.claim(join, L0.InstanceOf, STR.ConnectionJoin);
                map.put(key, join);
            } catch(DatabaseException e) {
                throw new RuntimeDatabaseException(e);
            }
        }
        return join;
    }

}
