/*******************************************************************************
 * Copyright (c) 2022 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.Preferences;

/**
 * @author Tuukka Lehtonen
 * @since 1.51.0
 */
public class SCLIssuePreferenceInitializer extends AbstractPreferenceInitializer {

	public void initializeDefaultPreferences() {
		boolean expressionIssuesEnabled = "true".equalsIgnoreCase(
				System.getProperty(
						SCLIssuePreferences.PROP_SCL_EXPRESSION_ISSUES_ENABLED,
						Boolean.toString(SCLIssuePreferences.DEFAULT_SCL_EXPRESSION_ISSUES_ENABLED)));

		IScopeContext context = DefaultScope.INSTANCE;
		Preferences node = context.getNode(SCLIssuePreferences.P_NODE);
		node.putBoolean(SCLIssuePreferences.P_SCL_EXPRESSION_ISSUES_ENABLED, expressionIssuesEnabled);
	}

}