package org.simantics.modeling.adapters;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IsParent;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public class TypicalMasterRemover extends ExistingInstancesRemover {

	public TypicalMasterRemover(Resource resource, String typeDescription) {
		super(resource, typeDescription);
	}

	@Override
	public void remove(WriteGraph graph) throws DatabaseException {
		// In typical masters the actual typical type is defined as a part of
		// the master instance itself. Therefore we need to customize this code
		// to look for the correct type.
		for (Resource type : graph.getPrincipalTypes(resource)) {
			if (graph.syncRequest(new IsParent(resource, type))) {
				remove(graph, resource, type, resource);
				return;
			}
		}

		// Typical type not found. Just remove, no questions asked.
		justRemove(graph);
	}

}