/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message.util;

import java.net.URI;
import java.net.URISyntaxException;

import org.simantics.db.Resource;
import org.simantics.db.ResourceSerializer;
import org.simantics.db.Session;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.message.ReferenceSerializationException;

/**
 * @author Tuukka Lehtonen
 */
public class ResourceSerializerUtil {

    public static Resource deserialize(Session s, URI data) throws ReferenceSerializationException {
    	SerialisationSupport support = s.getService(SerialisationSupport.class);
        ResourceSerializer rs = support.getResourceSerializer();
        try {
            return rs.getResource(data.getSchemeSpecificPart());
        } catch (InvalidResourceReferenceException e) {
            throw new ReferenceSerializationException(e);
        }
    }

    public static URI serialize(Session s, Resource r) throws ReferenceSerializationException {
    	SerialisationSupport support = s.getService(SerialisationSupport.class);
        ResourceSerializer rs = support.getResourceSerializer();
        try {
            return new URI("resource", rs.createRandomAccessId(r), null);
        } catch (InvalidResourceReferenceException e) {
            throw new ReferenceSerializationException(e);
        } catch (URISyntaxException e) {
            throw new ReferenceSerializationException(e);
        }
    }

}
