/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message;

import org.eclipse.core.runtime.IStatus;

/**
 * A log to which status events can be written. Logs appear on individual
 * plug-ins and on the platform itself. Clients can register log listeners which
 * will receive notification of all log events as they come in.
 * 
 * @author Tuukka Lehtonen
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface ILogger {

    /**
     * Adds the given log listener to this log.  Subsequently the log listener will
     * receive notification of all log events passing through this log.
     * This method has no affect if the identical listener is already registered on this log.
     *
     * @param listener the listener to add to this log
     */
    public void addLogListener(ILogListener listener);

    /**
     * Returns an identifier name for this log.
     *
     * @return the identifier name for this log
     */
    public String getName();

    /**
     * Logs the given status.  The status is distributed to the log listeners
     * installed on this log and then to the log listeners installed on the platform.
     *
     * @param status the status to log
     */
    public void log(IStatus status);

    /**
     * Removes the given log listener to this log.  Subsequently the log listener will
     * no longer receive notification of log events passing through this log.  
     * This method has no affect if the identical listener is not registered on this log.
     *
     * @param listener the listener to remove
     */
    public void removeLogListener(ILogListener listener);

}
