/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.mapping.IContextualModification;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class ProfileInstruction implements IInstruction {

	String name;
	IInstruction instruction;	
	
	public ProfileInstruction(String name, IInstruction instruction) {
		this.name = name;
		this.instruction = instruction;
	}

	@Override
	public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
		ITask task = ThreadLogger.getInstance().begin(name + ".claim");
		final IContextualModification modi = instruction.claim(g, bindings);
		task.finish();
		if(modi==null)
			return null;
		return new IContextualModification() {

			@Override
			public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
				ITask task = ThreadLogger.getInstance().begin(name + ".claim.perform");
				modi.perform(g, bindings);
				task.finish();
			}
			
		};
	}

	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
		instruction.collectVariables(reads, writes);		
	}

	@Override
	public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
		ITask task = ThreadLogger.getInstance().begin(name + ".deny");
		final IContextualModification modi = instruction.deny(g, bindings);
		task.finish();
		if(modi==null)
			return null;
		return new IContextualModification() {

			@Override
			public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
				ITask task = ThreadLogger.getInstance().begin(name + ".deny.perform");
				modi.perform(g, bindings);
				task.finish();
			}
			
		};
	}

	@Override
	public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
		ITask task = ThreadLogger.getInstance().begin(name + ".doClaim");
		instruction.doClaim(g, bindings);
		task.finish();		
	}

	@Override
	public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
		ITask task = ThreadLogger.getInstance().begin(name + ".doDeny");
		instruction.doDeny(g, bindings);
		task.finish();		
	}

	@Override
	public void mapVariables(TIntIntHashMap map) {
		instruction.mapVariables(map);
	}

	@Override
	public Object next(ReadGraph g, Object[] bindings, Object continuation) throws DatabaseException {
		return instruction.next(g, bindings, continuation);
	}

	@Override
	public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
		ITask task = ThreadLogger.getInstance().begin(name + ".query");
		Object ret = instruction.query(g, bindings);
		task.finish();
		return ret;
	}

	@Override
	public void toString(StringBuilder b, int indent) {
		instruction.toString(b, indent);
	}

}
