/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint;

import gnu.trove.map.hash.TObjectIntHashMap;

import java.util.Arrays;

import org.simantics.db.Resource;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class ExistsConstraint implements IConstraint {

	IConstraint constraint;
	Resource[] variables;
	
	public ExistsConstraint(IConstraint constraint, Resource[] variables) {
		this.constraint = constraint;
		this.variables = Arrays.copyOf(variables, variables.length);
	}

	@Override
	public ImmutableSet<Resource> binds() {
		return constraint.binds();
	}

	@Override
	public IInstruction createInstruction(
			TObjectIntHashMap<Resource> variableIds,
			ImmutableSet<Resource> bound)
			throws TooManyUnboundVariablesException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int isApplicable(ImmutableSet<Resource> bound) {
		// TODO Auto-generated method stub
		return 0;
	}
	
}
