/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.simantics.logging.LogProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackLogProvider
implements LogProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogbackLogProvider.class);

    @Override
    public List<Path> get() {
        ArrayList<Path> logs = new ArrayList<Path>();
        try {
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            ch.qos.logback.classic.Logger logger = context.getLogger("ROOT");
            Iterator appenderIter = logger.iteratorForAppenders();
            while (appenderIter.hasNext()) {
                FileAppender<ILoggingEvent> appender = LogbackLogProvider.findFileAppender((Appender<ILoggingEvent>)((Appender)appenderIter.next()));
                if (appender != null) {
                    String logFile = appender.getFile();
                    Path log = Paths.get(logFile, new String[0]).toAbsolutePath();
                    if (appender instanceof RollingFileAppender) {
                        Path parent = log.getParent();
                        List newLogs = Files.walk(parent, new FileVisitOption[0]).collect(Collectors.toList());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Found {} from {}", newLogs, appender);
                        }
                        logs.addAll(newLogs);
                        continue;
                    }
                    logs.add(log);
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Appender is not {} but is {} instead", (Object)FileAppender.class.getName(), (Object)(appender != null ? appender.getClass().getName() : "null"));
            }
        }
        catch (ClassCastException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Seems like we are not using logback but {} instead", (Object)LoggerFactory.getILoggerFactory(), (Object)e);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Could not collect logs", t);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found {} log files : {}", (Object)logs.size(), logs);
        }
        return logs;
    }

    private static FileAppender<ILoggingEvent> findFileAppender(Appender<ILoggingEvent> appender) {
        if (appender instanceof AppenderAttachable) {
            Iterator children = ((AppenderAttachable)appender).iteratorForAppenders();
            while (children.hasNext()) {
                FileAppender<ILoggingEvent> app = LogbackLogProvider.findFileAppender((Appender<ILoggingEvent>)((Appender)children.next()));
                if (app == null) continue;
                return app;
            }
            return null;
        }
        if (appender instanceof FileAppender) {
            return (FileAppender)appender;
        }
        return null;
    }
}

