/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.contribution;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.model.imagedecorators.ImageDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.issues.Severity;
import org.simantics.issues.common.MaxIssueSeverityRecursive;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.issues.ui.internal.Activator;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.gfx.DecorationOverlayIcon;

public class IssueImageDecorationRule
implements ImageDecorationRule {
    Set<Resource> typesToSearch;

    public IssueImageDecorationRule(ReadGraph graph, String typeToSearch) throws DatabaseException {
        this(graph, new String[]{typeToSearch});
    }

    public IssueImageDecorationRule(ReadGraph graph, String type1, String type2) throws DatabaseException {
        this(graph, new String[]{type1, type2});
    }

    public IssueImageDecorationRule(ReadGraph graph, String ... typesToSearch) throws DatabaseException {
        this.typesToSearch = new HashSet<Resource>(typesToSearch.length);
        String[] stringArray = typesToSearch;
        int n = typesToSearch.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            this.typesToSearch.add(graph.getResource(uri));
            ++n2;
        }
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public ImageDecorator getImageDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Resource r = (Resource)content;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource.getInstance((ReadGraph)graph);
        Severity maxSeverity = (Severity)graph.syncRequest((Read)new MaxIssueSeverityRecursive(r, L0.ConsistsOf, this.typesToSearch));
        if (maxSeverity == null) {
            return null;
        }
        final Severity severity = maxSeverity;
        return new ImageDecorator(){

            public <Image> Image decorateImage(Image image, String column, int itemIndex) {
                return (Image)IssueImageDecorationRule.this.getDecoration((ImageDescriptor)image, severity);
            }
        };
    }

    private ImageDescriptor getDecoration(ImageDescriptor original, Severity severity) {
        ImageDescriptor img = Activator.getDefault().getImageRegistry().getDescriptor(severity.toString());
        return original == null || original.getImageData() == null ? img : new DecorationOverlayIcon(original, img, 2);
    }
}

