/*******************************************************************************
 * Copyright (c) 2007, 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - Reorganization
 *******************************************************************************/
package org.simantics.issues.common;

import java.util.List;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.operation.Layer0X;
import org.simantics.scl.db.SCLFunctions;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.simulation.ontology.SimulationResource;

import gnu.trove.set.hash.THashSet;

/**
 * @author Tuukka Lehtonen
 */
public class AllVisibleIssues extends BinaryRead<Resource, Boolean, Set<Variable>> {

    public AllVisibleIssues(Resource project) {
        super(project, Boolean.FALSE);
    }

    public AllVisibleIssues(Resource project, boolean onlyUnresolved) {
        super(project, onlyUnresolved);
    }

    @Override
    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {

        Layer0X L0X = Layer0X.getInstance(graph);
        SimulationResource SIMU = SimulationResource.getInstance(graph);
        Set<Variable> result = new THashSet<>();

        for (Resource model : graph.syncRequest(new ObjectsWithType(parameter, L0X.Activates, SIMU.Model))) {
            result.addAll(graph.syncRequest(new ModelVisibleIssues(model, false)));
        }

        List<Resource> libraries = SCLFunctions.evaluateGraph("Simantics/SharedOntologies", "getSharedOntologies", graph, Tuple0.INSTANCE); 
        for (Resource library : libraries) {
            result.addAll(graph.syncRequest(new ModelVisibleIssues(library, false)));
        }

        return result;

    }

}
