/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.image.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Write;
import org.simantics.image.ui.CreateImages;
import org.simantics.image.ui.ImageSource;
import org.simantics.image.ui.Messages;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.AdaptionUtils;

public class ImportImagesActionFactory
implements ActionFactory {
    public Runnable create(Object target) {
        final Resource container = (Resource)AdaptionUtils.adaptToSingle((Object)target, Resource.class);
        if (container == null) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (win == null) {
                    return;
                }
                Collection<File> files = ImportImagesActionFactory.requestImportedImages(win.getShell());
                if (files.isEmpty()) {
                    return;
                }
                Simantics.getSession().markUndoPoint();
                Simantics.getSession().asyncRequest((Write)new CreateImages(container, files));
            }
        };
    }

    public static Collection<File> requestImportedImages(Shell parentShell) {
        FileDialog dialog = new FileDialog(parentShell, 2);
        dialog.setText(Messages.ImportImagesActionFactory_ChooseImageToBeImported);
        dialog.setFilterExtensions(new String[]{"*.jpg;*.png;*.gif;*.svg", "*.jpg;*.jpeg", "*.png", "*.gif", "*.svg"});
        dialog.setFilterNames(new String[]{Messages.ImportImagesActionFactory_FilterAllImage, Messages.ImportImagesActionFactory_FilterJPEGImage, Messages.ImportImagesActionFactory_FilterPNGImage, Messages.ImportImagesActionFactory_FilterGIFImages, Messages.ImportImagesActionFactory_FilterSVGImage});
        String filename = dialog.open();
        if (filename == null) {
            return Collections.emptyList();
        }
        String[] files = dialog.getFileNames();
        File parent = new File(dialog.getFilterPath());
        ArrayList<File> result = new ArrayList<File>(files.length);
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            result.add(new File(parent, file));
            ++n2;
        }
        return result;
    }

    public static ImageSource toImageSource(File file) throws IOException {
        ImageSource src = new ImageSource();
        src.name = file.getName();
        src.data = FileUtils.readFile((File)file);
        return src;
    }
}

