/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.help.base.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.search.IHelpSearchIndex;
import org.eclipse.help.search.ISearchDocument;
import org.eclipse.help.search.SearchParticipant;
import org.osgi.framework.Bundle;
import org.simantics.help.base.internal.PDFUtil;

public class PDFSearchParticipant
extends SearchParticipant {
    public IStatus addDocument(IHelpSearchIndex index, String pluginId, String name, URL url, String id, ISearchDocument doc) {
        try {
            Bundle bundle = Platform.getBundle((String)pluginId);
            if (bundle == null) {
                return new Status(4, pluginId, "Failed to find bundle " + String.valueOf(bundle) + " from the platform.");
            }
            Path path = new Path(URLDecoder.decode(name, "UTF-8"));
            URL bundleUrl = FileLocator.find((Bundle)bundle, (IPath)(path = path.removeFirstSegments(1)), null);
            if (bundleUrl == null) {
                return new Status(4, pluginId, "Failed to find file " + name + " from bundle " + pluginId + ".");
            }
            URL fileUrl = FileLocator.toFileURL((URL)bundleUrl);
            if (!fileUrl.getProtocol().equals("file")) {
                return new Status(4, pluginId, "Failed to make " + String.valueOf(url) + " available as a file");
            }
            File f = new File(URLDecoder.decode(fileUrl.getPath(), "UTF-8")).getCanonicalFile();
            PDFUtil.stripText(f, doc);
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return new Status(4, pluginId, "Failed to strip text from PDF document " + String.valueOf(url) + ".", (Throwable)e);
        }
    }
}

