/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz.ui;

import java.awt.Canvas;
import java.awt.Frame;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.continuation.Computation;
import org.simantics.graphviz.continuation.Continuation;
import org.simantics.graphviz.drawable.Drawable;
import org.simantics.graphviz.drawable.GraphDrawable2;
import org.simantics.graphviz.drawable.ViewerCanvas;

public class GraphvizComponent2
extends Composite {
    Canvas canvas;
    GraphDrawable2 drawable;
    Graph graph;
    AtomicBoolean initialized = new AtomicBoolean(false);
    Frame frame = SWT_AWT.new_Frame((Composite)this);

    public GraphvizComponent2(Composite parent, int style) {
        super(parent, style | 0x1000000 | 0x40000);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GraphvizComponent2.this.drawable = new GraphDrawable2();
                    GraphvizComponent2.this.canvas = new ViewerCanvas((Drawable)GraphvizComponent2.this.drawable);
                    GraphvizComponent2.this.frame.add(GraphvizComponent2.this.canvas);
                }
                catch (Throwable throwable) {
                    AtomicBoolean atomicBoolean = GraphvizComponent2.this.initialized;
                    synchronized (atomicBoolean) {
                        GraphvizComponent2.this.initialized.set(true);
                        GraphvizComponent2.this.initialized.notifyAll();
                    }
                    throw throwable;
                }
                AtomicBoolean atomicBoolean = GraphvizComponent2.this.initialized;
                synchronized (atomicBoolean) {
                    GraphvizComponent2.this.initialized.set(true);
                    GraphvizComponent2.this.initialized.notifyAll();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilInitialized() {
        try {
            AtomicBoolean atomicBoolean = this.initialized;
            synchronized (atomicBoolean) {
                while (!this.initialized.get()) {
                    this.initialized.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new Error("GraphvizComponent AWT population interrupted for class " + String.valueOf((Object)this), e);
        }
    }

    public Computation<Graph> setGraph(Graph graph) {
        return this.setGraph(graph, "dot");
    }

    public Computation<Graph> setGraph(Graph graph, String algorithm) {
        Computation computation = this.drawable.setGraph(graph, algorithm);
        computation.addContinuation((Continuation)new Continuation<Graph>(){

            public void succeeded(Graph result) {
                if (GraphvizComponent2.this.isDisposed()) {
                    return;
                }
                GraphvizComponent2.this.fit();
            }

            public void failed(Exception exception) {
            }
        });
        return computation;
    }

    public void fit() {
        ((ViewerCanvas)this.canvas).fit();
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GraphvizComponent2.this.redraw();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphvizComponent2.this.canvas.repaint();
            }
        });
    }

    public void requestFocus() {
        if (this.canvas != null) {
            this.canvas.requestFocus();
        }
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public GraphDrawable2 getDrawable() {
        return this.drawable;
    }
}

