/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz.internal.xdot;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class Text implements DrawCommand {

	double x;
	double y;
	double j;
	double w;
	String text;
	
	public Text(double x, double y, int j, double w, String text) {
		this.x = x;
		this.y = -y;
		this.j = j;
		this.w = w;
		this.text = text;
	}

	@Override
	public void draw(Graphics2D g) {
	    double lx;
	    
	    if(j == -1)
            lx = x;
        else if(j == 0)
            lx = x - 0.5*w;
        else if(j == 1)
            lx = x - w;
        else
            lx = x;
        //g.draw(new Line2D.Double(lx, y, lx+w, y));
	    g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, 
	        RenderingHints.VALUE_FRACTIONALMETRICS_ON);
	    Rectangle2D rect = g.getFont().getStringBounds(text, g.getFontRenderContext());
	    AffineTransform oldTransform = g.getTransform();
	    g.translate(lx, y);
	    double scale = w / rect.getWidth(); 
	    g.scale(scale, scale);
		g.drawString(text, 0.0f, 0.0f);
		g.setTransform(oldTransform);
	}
	
}
