/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphfile.adapters;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.graphfile.Activator;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.graphfile.util.GraphFileUtil;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.dialogs.ShowError;

public class ExportSystemResourcesActionFactory
implements ActionFactory {
    public Runnable create(Object _target) {
        final Resource target = (Resource)_target;
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Shell shell = Display.getCurrent().getActiveShell();
                    ResourceType type = ExportSystemResourcesActionFactory.this.getResourceType(target);
                    if (type == ResourceType.UNKNOW) {
                        return;
                    }
                    String name = ExportSystemResourcesActionFactory.this.getName(target);
                    String exportName = null;
                    if (type == ResourceType.FILE) {
                        dialog = new FileDialog(shell, 8192);
                        dialog.setFileName(name);
                        exportName = dialog.open();
                    } else {
                        dialog = new DirectoryDialog(shell, 8192);
                        exportName = dialog.open();
                    }
                    if (exportName == null) {
                        return;
                    }
                    File targetFile = new File(exportName);
                    if (type == ResourceType.FILE) {
                        ExportSystemResourcesActionFactory.this.exportFile(shell, targetFile, target);
                    } else {
                        ExportSystemResourcesActionFactory.this.exportFolder(shell, targetFile, target);
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, "Failed to export file/folder to disk: " + String.valueOf(target), (Throwable)e));
                    ShowError.showError((String)"Error", (String)e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    private String getName(final Resource resource) throws DatabaseException {
        return (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                return (String)graph.getPossibleRelatedValue(resource, l0.HasName);
            }
        });
    }

    private ResourceType getResourceType(final Resource resource) throws DatabaseException {
        return (ResourceType)((Object)Simantics.getSession().syncRequest((Read)new Read<ResourceType>(){

            public ResourceType perform(ReadGraph graph) throws DatabaseException {
                GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(resource, gf.File)) {
                    return ResourceType.FILE;
                }
                if (graph.isInstanceOf(resource, gf.Folder)) {
                    return ResourceType.FOLDER;
                }
                return ResourceType.UNKNOW;
            }
        }));
    }

    private void exportFile(Shell shell, final File targetFile, final Resource target) throws Exception {
        if (targetFile.exists()) {
            if (!targetFile.isFile()) {
                MessageDialog.openError((Shell)shell, (String)"File Problem", (String)("Output target is not a file " + targetFile.getAbsolutePath()));
                return;
            }
            boolean ok = MessageDialog.openConfirm((Shell)shell, (String)"Overwrite", (String)("A file by the name " + targetFile.getAbsolutePath() + " contains files.\n\nDo you want to overwrite the files?"));
            if (!ok) {
                return;
            }
            if (!targetFile.delete()) {
                MessageDialog.openError((Shell)shell, (String)"Delete Problem", (String)("Could not overwrite previously existing file " + targetFile.getAbsolutePath()));
                return;
            }
        }
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                try {
                    GraphFileUtil.writeDataToFile(graph, target, targetFile);
                }
                catch (IOException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    private void exportFolder(Shell shell, final File targetFile, final Resource target) throws Exception {
        if (targetFile.exists()) {
            if (!targetFile.isDirectory()) {
                MessageDialog.openError((Shell)shell, (String)"Folder Problem", (String)("Output target is not a folder " + targetFile.getAbsolutePath()));
                return;
            }
            String[] files = targetFile.list();
            if (files.length > 0) {
                boolean ok = MessageDialog.openConfirm((Shell)shell, (String)"Overwrite", (String)("A folder by the name " + targetFile.getAbsolutePath() + " contains files.\n\nDo you want to overwrite the files?"));
                if (!ok) {
                    return;
                }
                GraphFileUtil.clearDirectoryStructure(targetFile);
            }
        } else if (!targetFile.mkdir()) {
            MessageDialog.openError((Shell)shell, (String)"Folder Problem", (String)("Could not create new folder " + String.valueOf(targetFile)));
            return;
        }
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                try {
                    GraphFileUtil.writeFolderToDisk(graph, target, targetFile);
                }
                catch (IOException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    static enum ResourceType {
        FILE,
        FOLDER,
        UNKNOW;

    }
}

