/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.representation;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

public class TransferableGraphUtils {
    public static final int NOT_FOUND = -2;

    public static Collection<Identity> getRoots(TransferableGraph1 tg) {
        ArrayList<Identity> result = new ArrayList<Identity>();
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof Root) {
                result.add(id);
            }
            ++n2;
        }
        return result;
    }

    public static Identity findRootWithName(TransferableGraph1 tg, String name) {
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof Root) {
                Root ext = (Root)id.definition;
                if (ext.name.equals(name)) {
                    return id;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Identity findExternalWithName(TransferableGraph1 tg, String name) {
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof External) {
                External ext = (External)id.definition;
                if (ext.name.equals(name)) {
                    return id;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Identity findExternalWithNameAndParent(TransferableGraph1 tg, int parent, String name) {
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof External) {
                External ext = (External)id.definition;
                if (ext.name.equals(name) && ext.parent == parent) {
                    return id;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Identity findExternal(TransferableGraph1 tg, String uri) {
        String[] tokens;
        Identity identity = TransferableGraphUtils.findExternalWithName(tg, "http:/");
        if (identity == null) {
            identity = TransferableGraphUtils.findExternalWithName(tg, "");
        }
        if (identity == null) {
            identity = TransferableGraphUtils.findRootWithName(tg, "");
        }
        if ("http:/".equals(uri)) {
            return identity;
        }
        String[] stringArray = tokens = uri.substring("http://".length()).split("/");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            identity = TransferableGraphUtils.findExternalWithNameAndParent(tg, identity.resource, URIStringUtils.unescape((String)token));
            if (identity == null) {
                return null;
            }
            ++n2;
        }
        return identity;
    }

    public static Identity getIdentity2(TransferableGraph1 tg, String uri_) {
        Collection<Identity> identities = TransferableGraphUtils.getRoots(tg);
        for (Identity i : identities) {
            Identity id = TransferableGraphUtils.getIdentity2(tg, uri_, i);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    public static Identity getIdentity2(TransferableGraph1 tg, String uri_, Identity id) {
        String uri = TransferableGraphUtils.getURI(tg, id.resource);
        if (uri_.equals(uri)) {
            return id;
        }
        if (uri_.startsWith(uri)) {
            Collection<Identity> childIdentitiesOfRoot = TransferableGraphUtils.getChildren2(tg, id);
            for (Identity i2 : childIdentitiesOfRoot) {
                Identity id2 = TransferableGraphUtils.getIdentity2(tg, uri_, i2);
                if (id2 == null) continue;
                return id2;
            }
        }
        return null;
    }

    public static Identity getIdentity(TransferableGraph1 tg, int resource) {
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.resource == resource) {
                return id;
            }
            ++n2;
        }
        return null;
    }

    public static TIntArrayList getStatements(TransferableGraph1 tg, int resource) {
        TIntArrayList result = new TIntArrayList();
        int i = 0;
        while (i < tg.statements.length) {
            if (tg.statements[i] == resource) {
                result.add(tg.statements[i + 1]);
                result.add(tg.statements[i + 3]);
            }
            i += 4;
        }
        return result;
    }

    public static Collection<Identity> getChildren2(TransferableGraph1 tg, Identity parent) {
        return TransferableGraphUtils.getChildren2(tg, parent.resource);
    }

    public static Collection<Identity> getChildren2(TransferableGraph1 tg, int parentResource) {
        Internal internal;
        TreeMap<String, Identity> result = new TreeMap<String, Identity>();
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof Internal) {
                internal = (Internal)id.definition;
                if (internal.parent == parentResource) {
                    result.put(internal.name, id);
                }
            }
            ++n2;
        }
        Identity consistsOf = TransferableGraphUtils.findExternal(tg, "http://www.simantics.org/Layer0-1.1/ConsistsOf");
        Identity hasName = TransferableGraphUtils.findExternal(tg, "http://www.simantics.org/Layer0-1.1/HasName");
        if (consistsOf != null && hasName != null) {
            int i = 0;
            while (i < tg.statements.length) {
                if (tg.statements[i] == parentResource && tg.statements[i + 1] == consistsOf.resource) {
                    Identity identity = TransferableGraphUtils.getIdentity(tg, tg.statements[i + 3]);
                    if (identity != null) {
                        if (identity.definition instanceof Internal) {
                            internal = (Internal)identity.definition;
                            result.put(internal.name, identity);
                        }
                    } else {
                        Value value;
                        int possibleNameResource = TransferableGraphUtils.getPossibleObject2(tg, tg.statements[i + 3], hasName);
                        if (possibleNameResource != -2 && (value = TransferableGraphUtils.findValue(tg, possibleNameResource)) != null) {
                            try {
                                String name = (String)value.value.getValue((Binding)Bindings.STRING);
                                result.put(name, new Identity(tg.statements[i + 3], new Internal(tg.statements[i], name)));
                            }
                            catch (AdaptException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                i += 4;
            }
        }
        return result.values();
    }

    @Deprecated
    public static Collection<Identity> getChildren(TransferableGraph1 tg, Identity parent) {
        Internal internal;
        TreeMap<String, Identity> result = new TreeMap<String, Identity>();
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof Internal) {
                internal = (Internal)id.definition;
                if (internal.parent == parent.resource) {
                    result.put(internal.name, id);
                }
            }
            ++n2;
        }
        Identity consistsOf = TransferableGraphUtils.findExternal(tg, "http://www.simantics.org/Layer0-1.1/ConsistsOf");
        Identity hasName = TransferableGraphUtils.findExternal(tg, "http://www.simantics.org/Layer0-1.1/HasName");
        int i = 0;
        while (i < tg.statements.length) {
            if (tg.statements[i] == parent.resource && tg.statements[i + 1] == consistsOf.resource) {
                Identity identity = TransferableGraphUtils.getIdentity(tg, tg.statements[i + 3]);
                if (identity != null) {
                    if (identity.definition instanceof Internal) {
                        internal = (Internal)identity.definition;
                        result.put(internal.name, identity);
                    }
                } else {
                    Value value;
                    int possibleNameResource = TransferableGraphUtils.getPossibleObject(tg, tg.statements[i + 3], hasName);
                    if (possibleNameResource != 0 && (value = TransferableGraphUtils.findValue(tg, possibleNameResource)) != null) {
                        try {
                            String name = (String)value.value.getValue((Binding)Bindings.STRING);
                            result.put(name, new Identity(tg.statements[i + 3], new Internal(tg.statements[i], name)));
                        }
                        catch (AdaptException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            i += 4;
        }
        return result.values();
    }

    public static TIntArrayList getObjects(TransferableGraph1 tg, int subject, Identity predicate) {
        TIntArrayList result = new TIntArrayList();
        int i = 0;
        while (i < tg.statements.length) {
            if (tg.statements[i] == subject && tg.statements[i + 1] == predicate.resource) {
                result.add(tg.statements[i + 3]);
            }
            i += 4;
        }
        return result;
    }

    @Deprecated
    public static int getPossibleObject(TransferableGraph1 tg, int subject, Identity predicate) {
        int result = 0;
        int i = 0;
        while (i < tg.statements.length) {
            if (tg.statements[i] == subject && tg.statements[i + 1] == predicate.resource) {
                if (result != 0 && tg.statements[i + 3] != result) {
                    return 0;
                }
                result = tg.statements[i + 3];
            }
            i += 4;
        }
        return result;
    }

    public static int getPossibleObject2(TransferableGraph1 tg, int subject, Identity predicate) {
        int result = -2;
        int i = 0;
        while (i < tg.statements.length) {
            if (tg.statements[i] == subject && tg.statements[i + 1] == predicate.resource) {
                if (result != -2 && tg.statements[i + 3] != result) {
                    return -2;
                }
                result = tg.statements[i + 3];
            }
            i += 4;
        }
        return result;
    }

    @Deprecated
    public static int getPossibleObject(TransferableGraph1 tg, Identity subject, String predicate) {
        Identity p = TransferableGraphUtils.findExternal(tg, predicate);
        if (p == null) {
            return 0;
        }
        return TransferableGraphUtils.getPossibleObject(tg, subject.resource, p);
    }

    public static int getPossibleObject2(TransferableGraph1 tg, Identity subject, String predicate) {
        Identity p = TransferableGraphUtils.findExternal(tg, predicate);
        if (p == null) {
            return -2;
        }
        return TransferableGraphUtils.getPossibleObject2(tg, subject.resource, p);
    }

    public static Map<Identity, String> getNames(TransferableGraph1 tg, Collection<Identity> ids) {
        HashMap<Identity, String> result = new HashMap<Identity, String>();
        for (Identity id : ids) {
            if (!(id.definition instanceof Internal)) continue;
            Internal internal = (Internal)id.definition;
            result.put(id, internal.name);
        }
        return result;
    }

    public static String getName(TransferableGraph1 tg, Identity id) {
        return TransferableGraphUtils.getName(id);
    }

    public static String getName(Identity id) {
        if (id.definition instanceof Internal) {
            Internal internal = (Internal)id.definition;
            return internal.name;
        }
        if (id.definition instanceof External) {
            External external = (External)id.definition;
            return external.name;
        }
        if (id.definition instanceof Root) {
            Root root = (Root)id.definition;
            return root.name;
        }
        Optional optional = (Optional)id.definition;
        return optional.name;
    }

    public static String getRootType(Identity id) {
        if (id.definition instanceof Root) {
            Root root = (Root)id.definition;
            return root.type;
        }
        throw new IllegalArgumentException("Expected root, got " + String.valueOf(id));
    }

    public static Value findValue(TransferableGraph1 tg, int subject) {
        Value[] valueArray = tg.values;
        int n = tg.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            if (v.resource == subject) {
                return v;
            }
            ++n2;
        }
        return null;
    }

    public static String getURI(TransferableGraph1 tg, int id) {
        return TransferableGraphUtils.getURI(tg.identities, id);
    }

    public static String getURI(Identity[] identities, int id) {
        Identity[] identityArray = identities;
        int n = identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            if (identity.resource == id) {
                IdentityDefinition definition = identity.definition;
                if (definition instanceof External) {
                    External def = (External)definition;
                    if (def.parent == -1) {
                        return "http:/";
                    }
                    return TransferableGraphUtils.getURI(identities, def.parent) + "/" + URIStringUtils.escape((String)def.name);
                }
                if (definition instanceof Root) {
                    Root def = (Root)definition;
                    if (def.name.isEmpty()) {
                        return "http:/";
                    }
                    return def.name;
                }
                if (definition instanceof Internal) {
                    Internal def = (Internal)definition;
                    return TransferableGraphUtils.getURI(identities, def.parent) + "/" + URIStringUtils.escape((String)def.name);
                }
                return "";
            }
            ++n2;
        }
        return "<internal reference " + id + ">:";
    }

    public static TIntObjectMap<Identity> mapIdentities(TransferableGraph1 tg) {
        return TransferableGraphUtils.mapIdentities(tg.identities);
    }

    public static TIntObjectMap<Identity> mapIdentities(Identity[] identities) {
        TIntObjectHashMap map = new TIntObjectHashMap(identities.length, 0.5f, Integer.MIN_VALUE);
        Identity[] identityArray = identities;
        int n = identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            map.put(id.resource, (Object)id);
            ++n2;
        }
        return map;
    }

    public static String getURI(int resourceCount, TIntObjectMap<Identity> identities, int id) {
        Identity identity = (Identity)identities.get(id);
        if (identity != null) {
            IdentityDefinition definition = identity.definition;
            if (definition instanceof External) {
                External def = (External)definition;
                if (def.parent == -1) {
                    return "http:/";
                }
                return TransferableGraphUtils.getURI(resourceCount, identities, def.parent) + "/" + URIStringUtils.escape((String)def.name);
            }
            if (definition instanceof Root) {
                Root def = (Root)definition;
                if (def.name.isEmpty()) {
                    return "http:/";
                }
                return def.name;
            }
            if (definition instanceof Internal) {
                Internal def = (Internal)definition;
                return TransferableGraphUtils.getURI(resourceCount, identities, def.parent) + "/" + URIStringUtils.escape((String)def.name);
            }
            return "";
        }
        return "<internal reference " + id + ">:";
    }
}

