/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graph.representation;

import java.io.PrintStream;
import java.util.TreeMap;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;


/**
 * Transferable graph datatype. 
 * See <a href="http://dev.simantics.org/index.php/Transferable_Graph">specification</a>. 
 * @author Hannu Niemist&ouml;
 */
public class TransferableGraph1 {
	public static Binding BINDING = Bindings.getBindingUnchecked(TransferableGraph1.class);
	public static Serializer SERIALIZER = Bindings.getSerializerUnchecked(BINDING);
	
	public int resourceCount;
	public TreeMap<String, Variant> extensions;
	public Identity[] identities;	
	public int[] statements;
	public Value[] values;	
	
	public TransferableGraph1() {     
    }
	
	public TransferableGraph1(int resourceCount, Identity[] identities,
			int[] statements, Value[] values) {
		this(resourceCount, identities, statements, values,
				new TreeMap<String, Variant>());
	}
	
	public TransferableGraph1(int resourceCount, Identity[] identities,
			int[] statements, Value[] values, TreeMap<String, Variant> extensions) {
		this.resourceCount = resourceCount;
		this.identities = identities;
		this.statements = statements;
		this.values = values;
		this.extensions = extensions;
	}

	public void print() {
		print(System.out);
	}
	public void print(PrintStream out) {
		out.println("Resource count: " + resourceCount);
		out.println("Extensions: " + extensions.size());
		extensions.forEach((k,v) -> {
			out.println(k + ": " + v);
		});
		out.println("Identities: " + identities.length);
		for(int i = 0; i < identities.length; ++i) {
			Identity id = identities[i];
			out.print("  #" + i + ":  " + id.resource + " = ");
			if(id.definition instanceof Root) {
				Root def = (Root)id.definition;
				out.println("ROOT(" + def.name + ")");
			}
			else if(id.definition instanceof External) {
				External def = (External)id.definition;
				out.println("EXTERNAL(" + def.parent + ", " + def.name + ")");
			}
			else if(id.definition instanceof Internal) {
				Internal def = (Internal)id.definition;
				out.println("INTERNAL(" + def.parent + ", " + def.name + ")");
			}
		}
		out.println("Statements: " + statements.length/4);
		for(int i=0;i<statements.length;i+=4)
			out.println("  #" + i + ":  " + 
					statements[i] + " " +
					statements[i+1] + " " +
					statements[i+2] + " " +
					statements[i+3]
					);
		out.println("Values: " + values.length);
		for(int i=0;i<values.length;i++)
			out.println("  #" + i + ":  " + 
					values[i].resource + " " +
					values[i].value
					);
	}
}
