package org.simantics.graph.representation;

import java.util.TreeMap;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;

public class Extensions {

	public static final Binding BINDING = Bindings.getBindingUnchecked(Extensions.class);

	/**
	 * Used for storing a cached hash code computed from a
	 * {@link TransferableGraph1} instance in the metadata map of the
	 * <code>DataContainer</code> containing the TG.
	 */
	public final static String CACHED_HASHCODE = "cached.hashcode";

	final public static String CLUSTERING = "clustering";
	final public static String CLUSTER_SETS = "clusterSets";
	final public static int NO_CLUSTER_SET = -1;
	final public static int ROOT_LIBRARY_CLUSTER_SET = -1;
	final public static int INDEX_ROOT_CLUSTER_SET = -2;

	public TreeMap<String, Variant> map;

	public Extensions() {
		this.map = new TreeMap<>();
	}

	public Extensions(TreeMap<String, Variant> map) {
		this.map = map;
	}

}
