package org.simantics.graph.query;

import java.io.IOException;
import java.util.Collection;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.type.Datatype;

/**
 * Graph browsing interface for transferable graphs.
 * @author Hannu Niemist�
 */
public interface IGraph {

	/**
	 * Get value of the resource as variant. Returns null, if there is no value.
	 */
	Variant getValue(Res resource);

	/**
	 * Sets value of the resource.
	*/
	void setValue(Res resource, Object value, Binding binding);

	/**
	 * Gets the value of the resource using the given binding.
	 */
	Object getValue(Res resource, Binding binding) throws RuntimeSerializerConstructionException, SerializationException, IOException, BindingException, NoValueException;
	
	/**
	 * Gets the data type of the resource or null if it doesn't have a data type.
	 */
	Datatype getDatatype(Res resource);
	
	/**
	 * Gets raw objects without assertions
	 */
	Collection<Res> rawGetObjects(Res subject, Res predicate);
	
	/**
	 * Gets single raw object or throws NoUniqueObjectException if that is not possible
	 */
	Res singleRawObject(Res subject, Res predicate) throws NoUniqueObjectException;

	/**
	 * Gets raw and asserted objects.
	 */
	Collection<Res> getObjects(Res subject, Res predicate);
	
	/**
	 * Gets all types of the given resource
	 */
	Collection<Res> getTypes(Res resource);	
	
	/**
	 * Gets all instances of the given type
	 */
	Collection<Res> getInstances(Res type);

	Datatype getAssertedDatatype(Res type);
	
	Collection<Res> getChildren(Res res);
	
	Paths getPaths();    

}
