package org.simantics.graph.db;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.graph.representation.Root;

public class WrapperAdvisor implements IImportAdvisor2 {

    private final IImportAdvisor advisor;
    
    public WrapperAdvisor(IImportAdvisor advisor) {
        this.advisor = advisor;
    }
    
    @Override
    public void redirect(Resource temp) {
    	if(advisor instanceof IImportAdvisor2)
    		((IImportAdvisor2)advisor).redirect(temp);
    }
    
    @Override
    public Resource getTarget() {
    	if(advisor instanceof IImportAdvisor2)
    		return ((IImportAdvisor2)advisor).getTarget();
    	return null;
    }
    
    @Override
    public Collection<Resource> getRoots() {
    	if(advisor instanceof IImportAdvisor2)
    		return ((IImportAdvisor2)advisor).getRoots();
    	return null;
    }
    
    @Override
    public Collection<RootInfo> getRootInfo() {
    	if(advisor instanceof IImportAdvisor2)
    		return ((IImportAdvisor2)advisor).getRootInfo();
    	return null;
    }
    
    @Override
    public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
        return advisor.analyzeRoot(graph, root);
    }

    @Override
    public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
        return advisor.createRoot(graph, root);
    }

    @Override
    public Resource createRoot(WriteOnlyGraph graph, Root root, Resource resource) throws DatabaseException {
    	if(advisor instanceof IImportAdvisor2) {
    		return ((IImportAdvisor2)advisor).createRoot(graph, root, resource);
    	} else {
    		throw new UnsupportedOperationException();
    	}
    }

    @Override
    public void beforeWrite(WriteOnlyGraph graph, TransferableGraphImporter process)
            throws DatabaseException {
    	if(advisor instanceof IImportAdvisor2)
    		((IImportAdvisor2)advisor).beforeWrite(graph, process);
    }

    @Override
    public void afterWrite(WriteOnlyGraph graph, TransferableGraphImporter process)
            throws DatabaseException {
    	if(advisor instanceof IImportAdvisor2)
    		((IImportAdvisor2)advisor).afterWrite(graph, process);
    }

    @Override
    public boolean allowImmutableModifications() {
    	if(advisor instanceof IImportAdvisor2)
    		return ((IImportAdvisor2)advisor).allowImmutableModifications();
    	else
    		return false;
    }

    @Override
    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent,
            String name) throws DatabaseException {
    	if(advisor instanceof IImportAdvisor2)
    		return ((IImportAdvisor2)advisor).createChild(graph, process, parent, name);
    	else
    		return process.createChild(graph, parent, null, name);
    }

    @Override
    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, Resource child,
            String name) throws DatabaseException {
    	if(advisor instanceof IImportAdvisor2)
    		return ((IImportAdvisor2)advisor).createChild(graph, process, parent, child, name);
    	else
    		return process.createChild(graph, parent, child, name);
    }

}
