/*******************************************************************************
 * Copyright (c) 2017, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semamtum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.graph.db;

import java.util.Collection;
import java.util.Set;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;

/**
 * @author Tuukka Lehtonen
 * @since 1.28.0
 */
public class ImportResult {

	/**
	 * The importing process contains useful maps that may be needed in post-processing
	 */
	private final StreamingTransferableGraphImportProcess process;

	public ImportResult(StreamingTransferableGraphImportProcess process) {
		this.process = process;
	}

	public boolean hasMissingExternals() {
		return !process.missingExternals.isEmpty();
	}
	
	public Set<String> missingExternals() {
		return process.missingExternals;
	}
	
	public Collection<Resource> resolvedExternals(RequestProcessor processor) {
		return process.resolvedExternals(processor);
	}

}
