/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.gnuplot;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.simantics.gnuplot.GnuplotSession;
import org.simantics.gnuplot.InputStreamToFileCopier;

public class Gnuplot {
    private static final String GNUPLOT_VERSION_STRING_STARTS_WITH = "gnuplot ";
    private static final String GNUPLOT_ENV = "GNUPLOT";
    private static final String PATH_ENV = "PATH";
    private Path executable;

    public Gnuplot(Path executable) throws IOException {
        if (!Files.exists(executable, new LinkOption[0])) {
            throw new IOException("Provided gnuplot executable does not exist: " + String.valueOf(executable));
        }
        if (!Files.isExecutable(executable)) {
            throw new IOException("Provided gnuplot executable is not marked executable: " + String.valueOf(executable));
        }
        this.executable = executable;
    }

    public String toString() {
        return this.executable.toString();
    }

    public static Gnuplot detect() throws IOException {
        try {
            return new Gnuplot(Gnuplot.findGnuplotPath());
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private static String readInput(InputStream in) throws IOException {
        StringWriter sw = new StringWriter();
        int l = 0;
        while (l < GNUPLOT_VERSION_STRING_STARTS_WITH.length()) {
            int c = in.read();
            if (c <= 0) break;
            sw.write(c);
            ++l;
        }
        return sw.toString();
    }

    private static boolean testExecutable(Path exe) throws IOException, InterruptedException {
        Process process = new ProcessBuilder(exe.toString(), "-V").start();
        try {
            return GNUPLOT_VERSION_STRING_STARTS_WITH.startsWith(Gnuplot.readInput(process.getInputStream()));
            {
            }
        }
        finally {
            process.getInputStream().close();
            process.getErrorStream().close();
            process.waitFor();
        }
    }

    private static Path findExecutable(String[] paths, String executableName, boolean fail) throws IOException, InterruptedException {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            Path exe = Paths.get(p, new String[0]);
            if (executableName != null) {
                exe = exe.resolve(executableName);
            }
            if (Files.exists(exe, new LinkOption[0]) && Files.isExecutable(exe) && Gnuplot.testExecutable(exe)) {
                return exe;
            }
            ++n2;
        }
        if (fail) {
            throw new UnsupportedOperationException("Couldn't find executable '" + executableName + "' on the system path.");
        }
        return null;
    }

    private static Path findExecutable(String path, boolean splitPath, boolean fail) throws IOException, InterruptedException {
        switch (OSType.calculate()) {
            case APPLE: 
            case LINUX: 
            case SUN: {
                String[] stringArray;
                if (splitPath) {
                    stringArray = path.split(":");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = path;
                }
                return Gnuplot.findExecutable(stringArray, "gnuplot", fail);
            }
            case WINDOWS: {
                String[] stringArray;
                if (splitPath) {
                    stringArray = path.split(";");
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = path;
                }
                return Gnuplot.findExecutable(stringArray, "gnuplot.exe", fail);
            }
        }
        throw new UnsupportedOperationException("unsupported platform");
    }

    private static Path findGnuplotPath() throws IOException, InterruptedException {
        String path = System.getenv(GNUPLOT_ENV);
        if (path != null) {
            Path p = Gnuplot.findExecutable(new String[]{path}, null, false);
            if (p != null) {
                return p;
            }
            p = Gnuplot.findExecutable(path, false, false);
            if (p != null) {
                return p;
            }
            p = Gnuplot.findExecutable(path + "/bin", false, false);
            if (p != null) {
                return p;
            }
        }
        path = System.getenv(PATH_ENV);
        return Gnuplot.findExecutable(path, true, true);
    }

    private void execute0(Path workingDirectory, Path stdout, Path stderr, String ... cmdline) throws IOException {
        Thread stderrDumper;
        ProcessBuilder builder = new ProcessBuilder(cmdline).directory(workingDirectory.toFile());
        if (stdout != null) {
            builder.redirectOutput(stdout.toFile());
        }
        if (stderr != null) {
            builder.redirectError(stderr.toFile());
        }
        Process process = builder.start();
        Thread stdoutDumper = stdout == null ? new Thread(new InputStreamToFileCopier(process.getInputStream(), null)) : null;
        Thread thread = stderrDumper = stderr == null ? new Thread(new InputStreamToFileCopier(process.getErrorStream(), null)) : null;
        if (stdoutDumper != null) {
            stdoutDumper.start();
        }
        if (stderrDumper != null) {
            stderrDumper.start();
        }
        process.getOutputStream().close();
        try {
            if (stdoutDumper != null) {
                stdoutDumper.join();
            }
            if (stderrDumper != null) {
                stderrDumper.join();
            }
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void execute(Path workingDirectory, Path stdout, Path stderr, boolean redirectStderr, InputStream input, String charset) throws IOException {
        Throwable throwable = null;
        Object var8_9 = null;
        try (GnuplotSession session = this.newSession(workingDirectory, stdout, stderr, redirectStderr);){
            session.evaluateStream(input, charset);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void execute(Path workingDirectory, Path stdout, Path stderr, Path script) throws IOException {
        this.execute0(workingDirectory, stdout, stderr, this.executable.toString(), "-c", script.toString());
    }

    public void execute(Path workingDirectory, Path stdout, Path stderr, String ... commands) throws IOException {
        StringBuilder e = new StringBuilder().append('\"');
        boolean first = true;
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            if (!first) {
                e.append("; ");
            }
            first = false;
            e.append(cmd);
            ++n2;
        }
        e.append('\"');
        this.execute0(workingDirectory, stdout, stderr, this.executable.toString(), "-e", e.toString());
    }

    private ProcessBuilder buildSessionProcess(Path workingDirectory, Path stdout, Path stderr, boolean redirectErrorStream) {
        ProcessBuilder builder = new ProcessBuilder(this.executable.toString()).directory(workingDirectory != null ? workingDirectory.toFile() : null).redirectErrorStream(redirectErrorStream);
        if (stdout != null) {
            builder.redirectOutput(stdout.toFile());
        }
        if (stderr != null) {
            builder.redirectError(stderr.toFile());
        }
        return builder;
    }

    public GnuplotSession newSession(Path workingDirectory, Path stdout) throws IOException {
        return this.newSession(workingDirectory, stdout, null, true);
    }

    public GnuplotSession newSession(Path workingDirectory, Path stdout, Path stderr, boolean redirectStderr) throws IOException {
        return new GnuplotSession(workingDirectory, stdout == null, stderr == null, this.buildSessionProcess(workingDirectory, stdout, stderr, redirectStderr).start());
    }

    static final class OSType
    extends Enum<OSType> {
        public static final /* enum */ OSType APPLE = new OSType();
        public static final /* enum */ OSType LINUX = new OSType();
        public static final /* enum */ OSType SUN = new OSType();
        public static final /* enum */ OSType WINDOWS = new OSType();
        public static final /* enum */ OSType UNKNOWN = new OSType();
        private static final /* synthetic */ OSType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new OSType[]{APPLE, LINUX, SUN, WINDOWS, UNKNOWN};
        }

        public static OSType calculate() {
            String osName = System.getProperty("os.name");
            assert (osName != null);
            if ((osName = osName.toLowerCase()).startsWith("mac os x")) {
                return APPLE;
            }
            if (osName.startsWith("windows")) {
                return WINDOWS;
            }
            if (osName.startsWith("linux")) {
                return LINUX;
            }
            if (osName.startsWith("sun")) {
                return SUN;
            }
            return UNKNOWN;
        }

        public static OSType[] values() {
            OSType[] oSTypeArray = ENUM$VALUES;
            int n = oSTypeArray.length;
            OSType[] oSTypeArray2 = new OSType[n];
            System.arraycopy(ENUM$VALUES, 0, oSTypeArray2, 0, n);
            return oSTypeArray2;
        }

        public static OSType valueOf(String string) {
            return Enum.valueOf(OSType.class, string);
        }
    }
}

