/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.utils;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.simantics.g2d.utils.PathUtils;

public class PathUtils2 {
    public static Point2D getLineTangent(Shape line, double t, Point2D pt) {
        double x = 0.0;
        double y = 0.0;
        if (line instanceof Line2D) {
            Line2D l = (Line2D)line;
            x = l.getX1() - l.getX2();
            y = l.getY1() - l.getY2();
        } else if (line instanceof QuadCurve2D) {
            QuadCurve2D l = (QuadCurve2D)line;
            double p0x = l.getX1();
            double p0y = l.getY1();
            double p1x = l.getCtrlX();
            double p1y = l.getCtrlY();
            double p2x = l.getX2();
            double p2y = l.getY2();
            x = 2.0 * t * (p0x - 2.0 * p1x + p2x) + 2.0 * (-p0x + p1x);
            y = 2.0 * t * (p0y - 2.0 * p1y + p2y) + 2.0 * (-p0y + p1y);
        } else if (line instanceof CubicCurve2D) {
            CubicCurve2D l = (CubicCurve2D)line;
            double p0x = l.getX1();
            double p0y = l.getY1();
            double p1x = l.getCtrlX1();
            double p1y = l.getCtrlY1();
            double p2x = l.getCtrlX2();
            double p2y = l.getCtrlY2();
            double p3x = l.getX2();
            double p3y = l.getY2();
            x = 3.0 * (1.0 - t) * (1.0 - t) * (p1x - p2x) + 3.0 * (p2x - p1x) * 2.0 * t * (1.0 - t) + 3.0 * (p3x - p0x) * t * t;
            y = 3.0 * (1.0 - t) * (1.0 - t) * (p1y - p0y) + 3.0 * (p2y - p1y) * 2.0 * t * (1.0 - t) + 3.0 * (p3y - p2y) * t * t;
        } else {
            throw new IllegalArgumentException();
        }
        return new Point2D.Double(x, y);
    }

    public static Point2D getLinePos(Shape line, double t, Point2D pt) {
        assert (line != null);
        double x = 0.0;
        double y = 0.0;
        if (pt == null) {
            pt = new Point2D.Double();
        }
        if (line instanceof Line2D) {
            Line2D l = (Line2D)line;
            double p0x = l.getX1();
            double p0y = l.getY1();
            double p1x = l.getX2();
            double p1y = l.getY2();
            x = p0x * (1.0 - t) + t * p1x;
            y = p0y * (1.0 - t) + t * p1y;
        } else if (line instanceof QuadCurve2D) {
            QuadCurve2D l = (QuadCurve2D)line;
            double p0x = l.getX1();
            double p0y = l.getY1();
            double p1x = l.getCtrlX();
            double p1y = l.getCtrlY();
            double p2x = l.getX2();
            double p2y = l.getY2();
            double c2x = p0x - 2.0 * p1x + p2x;
            double c2y = p0y - 2.0 * p1y + p2y;
            double c1x = -2.0 * p0x + 2.0 * p1x;
            double c1y = -2.0 * p0y + 2.0 * p1y;
            double c0x = p0x;
            double c0y = p0y;
            x = t * t * c2x + t * c1x + c0x;
            y = t * t * c2y + t * c1y + c0y;
        } else if (line instanceof CubicCurve2D) {
            CubicCurve2D l = (CubicCurve2D)line;
            double p0x = l.getX1();
            double p0y = l.getY1();
            double p1x = l.getCtrlX1();
            double p1y = l.getCtrlY1();
            double p2x = l.getCtrlX2();
            double p2y = l.getCtrlY2();
            double p3x = l.getX2();
            double p3y = l.getY2();
            x = (1.0 - t) * (1.0 - t) * (1.0 - t) * p0x + 3.0 * t * (1.0 - t) * (1.0 - t) * p1x + 3.0 * t * t * (1.0 - t) * p2x + t * t * t * p3x;
            y = (1.0 - t) * (1.0 - t) * (1.0 - t) * p0y + 3.0 * t * (1.0 - t) * (1.0 - t) * p1y + 3.0 * t * t * (1.0 - t) * p2y + t * t * t * p3y;
        } else {
            throw new IllegalArgumentException();
        }
        pt.setLocation(x, y);
        return pt;
    }

    public static double getLineLength(Shape line) {
        if (line instanceof Line2D) {
            Line2D l = (Line2D)line;
            double dx = l.getX2() - l.getX1();
            double dy = l.getY2() - l.getY1();
            return Math.sqrt(dx * dx + dy * dy);
        }
        double result = 0.0;
        Point2D prevPos = PathUtils2.getLinePos(line, 0.0, null);
        int i = 0;
        while (i < 10) {
            double t = (double)(i + 1) / 10.0;
            Point2D pos = PathUtils2.getLinePos(line, t, null);
            result += pos.distance(prevPos);
            prevPos.setLocation(pos);
            ++i;
        }
        return result;
    }

    public static int getLineDegree(Shape line) {
        if (line instanceof Line2D) {
            return 1;
        }
        if (line instanceof QuadCurve2D) {
            return 2;
        }
        if (line instanceof CubicCurve2D) {
            return 3;
        }
        throw new IllegalArgumentException(String.valueOf(line) + " is not a shape");
    }

    public static double[] toArray(Shape line) {
        if (line instanceof Line2D) {
            Line2D l = (Line2D)line;
            return new double[]{l.getX1(), l.getY1(), l.getX2(), l.getY2()};
        }
        if (line instanceof QuadCurve2D) {
            QuadCurve2D l = (QuadCurve2D)line;
            return new double[]{l.getX1(), l.getY1(), l.getCtrlX(), l.getCtrlY(), l.getX2(), l.getY2()};
        }
        if (line instanceof CubicCurve2D) {
            CubicCurve2D l = (CubicCurve2D)line;
            return new double[]{l.getX1(), l.getY1(), l.getCtrlX1(), l.getCtrlY1(), l.getCtrlX2(), l.getCtrlY2(), l.getX2(), l.getY2()};
        }
        throw new IllegalArgumentException(String.valueOf(line) + " is not a shape");
    }

    public static Shape toShape(double[] dada) {
        if (dada.length == 4) {
            return new Line2D.Double(dada[0], dada[1], dada[2], dada[3]);
        }
        if (dada.length == 6) {
            return new QuadCurve2D.Double(dada[0], dada[1], dada[2], dada[3], dada[4], dada[5]);
        }
        if (dada.length == 8) {
            return new CubicCurve2D.Double(dada[0], dada[1], dada[2], dada[3], dada[4], dada[5], dada[6], dada[7]);
        }
        throw new IllegalArgumentException();
    }

    public static void interpolatePaths(List<Shape> l1, List<Shape> l2, double t, Collection<Shape> result) {
        if (l1.size() > l2.size()) {
            List<Shape> l_ = l1;
            l1 = l2;
            l2 = l_;
            t = 1.0 - t;
        }
        int div = l2.size() / l1.size();
        int mod = l2.size() % l1.size();
        int rightIndex = 0;
        int i = 0;
        while (i < l1.size()) {
            int rightCounterParts = i < l1.size() - 1 ? (i < mod ? div + 1 : div) : div;
            int leftIndex = i;
            Shape leftShape = l1.get(leftIndex);
            int j = 0;
            while (j < rightCounterParts) {
                Shape rightShape = l2.get(rightIndex++);
                double inv = 1.0 / (double)rightCounterParts;
                double t0 = (double)j * inv;
                double t1 = (double)(j + 1) * inv;
                Shape leftShapePart = PathUtils2.subdiv(leftShape, t0, t1);
                Shape intpShape = PathUtils2.interpolateLine(leftShapePart, rightShape, t);
                result.add(intpShape);
                ++j;
            }
            ++i;
        }
    }

    public static Path2D interpolatePaths(PathIterator path1, PathIterator path2, double t) {
        ArrayList<Shape> l1 = new ArrayList<Shape>();
        ArrayList<Shape> l2 = new ArrayList<Shape>();
        PathUtils2.toShapes(path1, l1);
        PathUtils2.toShapes(path2, l2);
        ArrayList<Shape> result = new ArrayList<Shape>();
        PathUtils2.interpolatePaths(l1, l2, t, result);
        Path2D.Double p = new Path2D.Double();
        PathUtils2.appedToPath((Path2D)p, result);
        return p;
    }

    public static Path2D interpolatePaths(Path2D path1, Path2D path2, double t) {
        return PathUtils2.interpolatePaths(path1.getPathIterator(null), path2.getPathIterator(null), t);
    }

    public static Shape interpolateLine(Shape l1, Shape l2, double t) {
        assert (t >= 0.0 && t <= 1.0);
        if (t == 0.0) {
            return l1;
        }
        if (t == 1.0) {
            return l2;
        }
        double[] a1 = PathUtils2.toArray(l1);
        double[] a2 = PathUtils2.toArray(l2);
        double[] res = PathUtils.interpolateLineSegment(a1, a2, t);
        return PathUtils2.toShape(res);
    }

    public static void toShapes(PathIterator pi, Collection<Shape> result) {
        Iterator<Shape> i = PathUtils2.toShapeIterator(pi);
        while (i.hasNext()) {
            Shape segment = i.next();
            result.add(segment);
        }
    }

    public static Iterator<Shape> toShapeIterator(PathIterator pi) {
        return new PathIteratorToShapeIterator(pi);
    }

    public static Shape subdiv_takeLeft(Shape line, double t) {
        if (t == 1.0) {
            return line;
        }
        if (line instanceof Line2D) {
            Line2D l = (Line2D)line;
            double p0x = l.getX1();
            double p0y = l.getY1();
            double p1x = l.getX2();
            double p1y = l.getY2();
            double p1x_ = p0x * (1.0 - t) + p1x * t;
            double p1y_ = p0y * (1.0 - t) + p1y * t;
            return new Line2D.Double(p0x, p0y, p1x_, p1y_);
        }
        if (line instanceof QuadCurve2D) {
            QuadCurve2D l = (QuadCurve2D)line;
            double p0x = l.getX1();
            double p0y = l.getY1();
            double p1x = l.getCtrlX();
            double p1y = l.getCtrlY();
            double p2x = l.getX2();
            double p2y = l.getY2();
            double p1x_ = p0x * (1.0 - t) + p1x * t;
            double p1y_ = p0y * (1.0 - t) + p1y * t;
            double q0x = p0x * (1.0 - t) + p1x * t;
            double q0y = p0y * (1.0 - t) + p1y * t;
            double q1x = p1x * (1.0 - t) + p2x * t;
            double q1y = p1y * (1.0 - t) + p2y * t;
            double p2x_ = q0x * (1.0 - t) + q1x * t;
            double p2y_ = q0y * (1.0 - t) + q1y * t;
            return new QuadCurve2D.Double(p0x, p0y, p1x_, p1y_, p2x_, p2y_);
        }
        if (line instanceof CubicCurve2D) {
            CubicCurve2D l = (CubicCurve2D)line;
            double p0x = l.getX1();
            double p0y = l.getY1();
            double p1x = l.getCtrlX1();
            double p1y = l.getCtrlY1();
            double p2x = l.getCtrlX2();
            double p2y = l.getCtrlY2();
            double p3x = l.getX2();
            double p3y = l.getY2();
            double p1x_ = p0x * (1.0 - t) + p1x * t;
            double p1y_ = p0y * (1.0 - t) + p1y * t;
            double q0x = p0x * (1.0 - t) + p1x * t;
            double q0y = p0y * (1.0 - t) + p1y * t;
            double q1x = p1x * (1.0 - t) + p2x * t;
            double q1y = p1y * (1.0 - t) + p2y * t;
            double p2x_ = q0x * (1.0 - t) + q1x * t;
            double p2y_ = q0y * (1.0 - t) + q1y * t;
            double q2x = p2x * (1.0 - t) + p3x * t;
            double q2y = p2y * (1.0 - t) + p3y * t;
            double r0x = q0x * (1.0 - t) + q1x * t;
            double r0y = q0y * (1.0 - t) + q1y * t;
            double r1x = q1x * (1.0 - t) + q2x * t;
            double r1y = q1y * (1.0 - t) + q2y * t;
            double p3x_ = r0x * (1.0 - t) + r1x * t;
            double p3y_ = r0y * (1.0 - t) + r1y * t;
            return new CubicCurve2D.Double(p0x, p0y, p1x_, p1y_, p2x_, p2y_, p3x_, p3y_);
        }
        throw new IllegalArgumentException();
    }

    public static Shape subdiv_takeRight(Shape line, double t) {
        if (t == 0.0) {
            return line;
        }
        if (line instanceof Line2D) {
            Line2D l = (Line2D)line;
            double p0x = l.getX1();
            double p0y = l.getY1();
            double p1x = l.getX2();
            double p1y = l.getY2();
            double p0x_ = p0x * (1.0 - t) + p1x * t;
            double p0y_ = p0y * (1.0 - t) + p1y * t;
            return new Line2D.Double(p0x_, p0y_, p1x, p1y);
        }
        if (line instanceof QuadCurve2D) {
            QuadCurve2D l = (QuadCurve2D)line;
            double p0x = l.getX1();
            double p0y = l.getY1();
            double p1x = l.getCtrlX();
            double p1y = l.getCtrlY();
            double p2x = l.getX2();
            double p2y = l.getY2();
            double q0x = p0x * (1.0 - t) + p1x * t;
            double q0y = p0y * (1.0 - t) + p1y * t;
            double q1x = p1x * (1.0 - t) + p2x * t;
            double q1y = p1y * (1.0 - t) + p2y * t;
            double p2x_ = q0x * (1.0 - t) + q1x * t;
            double p2y_ = q0y * (1.0 - t) + q1y * t;
            return new QuadCurve2D.Double(p2x_, p2y_, q1x, q1y, p2x, p2y);
        }
        if (line instanceof CubicCurve2D) {
            CubicCurve2D l = (CubicCurve2D)line;
            double p0x = l.getX1();
            double p0y = l.getY1();
            double p1x = l.getCtrlX1();
            double p1y = l.getCtrlY1();
            double p2x = l.getCtrlX2();
            double p2y = l.getCtrlY2();
            double p3x = l.getX2();
            double p3y = l.getY2();
            double q0x = p0x * (1.0 - t) + p1x * t;
            double q0y = p0y * (1.0 - t) + p1y * t;
            double q1x = p1x * (1.0 - t) + p2x * t;
            double q1y = p1y * (1.0 - t) + p2y * t;
            double q2x = p2x * (1.0 - t) + p3x * t;
            double q2y = p2y * (1.0 - t) + p3y * t;
            double r0x = q0x * (1.0 - t) + q1x * t;
            double r0y = q0y * (1.0 - t) + q1y * t;
            double r1x = q1x * (1.0 - t) + q2x * t;
            double r1y = q1y * (1.0 - t) + q2y * t;
            double p3x_ = r0x * (1.0 - t) + r1x * t;
            double p3y_ = r0y * (1.0 - t) + r1y * t;
            return new CubicCurve2D.Double(p3x_, p3y_, r1x, r1y, q2x, q2y, p3x, p3y);
        }
        return null;
    }

    public static Shape subdiv(Shape line, double t0, double t1) {
        if (t0 == 0.0 && t1 == 1.0) {
            return line;
        }
        Shape temp = PathUtils2.subdiv_takeLeft(line, t1);
        return PathUtils2.subdiv_takeRight(temp, t0 / t1);
    }

    public static void appedToPath(Path2D p, Shape ... shapes) {
        Shape[] shapeArray = shapes;
        if (shapes.length != 0) {
            Shape s = shapeArray[0];
            Point2D cur = p.getCurrentPoint();
            if (s instanceof Line2D) {
                Line2D l = (Line2D)s;
                if (cur.getX() != l.getX1() || cur.getY() != l.getY1()) {
                    p.moveTo(l.getX1(), l.getY1());
                }
                p.lineTo(l.getX2(), l.getY2());
            } else if (s instanceof QuadCurve2D) {
                QuadCurve2D l = (QuadCurve2D)s;
                if (cur.getX() != l.getX1() || cur.getY() != l.getY1()) {
                    p.moveTo(l.getX1(), l.getY1());
                }
                p.quadTo(l.getCtrlX(), l.getCtrlY(), l.getX2(), l.getY2());
            } else if (s instanceof CubicCurve2D) {
                CubicCurve2D l = (CubicCurve2D)s;
                if (cur.getX() != l.getX1() || cur.getY() != l.getY1()) {
                    p.moveTo(l.getX1(), l.getY1());
                }
                p.curveTo(l.getCtrlX1(), l.getCtrlY1(), l.getCtrlX2(), l.getCtrlY2(), l.getX2(), l.getY2());
            }
            throw new IllegalArgumentException();
        }
    }

    public static void appedToPath(Path2D p, Collection<Shape> shapes) {
        for (Shape s : shapes) {
            Shape l;
            Point2D cur = p.getCurrentPoint();
            if (s instanceof Line2D) {
                l = (Line2D)s;
                if (cur == null || cur.getX() != ((Line2D)l).getX1() || cur.getY() != ((Line2D)l).getY1()) {
                    p.moveTo(((Line2D)l).getX1(), ((Line2D)l).getY1());
                }
                p.lineTo(((Line2D)l).getX2(), ((Line2D)l).getY2());
                continue;
            }
            if (s instanceof QuadCurve2D) {
                l = (QuadCurve2D)s;
                if (cur == null || cur.getX() != ((QuadCurve2D)l).getX1() || cur.getY() != ((QuadCurve2D)l).getY1()) {
                    p.moveTo(((QuadCurve2D)l).getX1(), ((QuadCurve2D)l).getY1());
                }
                p.quadTo(((QuadCurve2D)l).getCtrlX(), ((QuadCurve2D)l).getCtrlY(), ((QuadCurve2D)l).getX2(), ((QuadCurve2D)l).getY2());
                continue;
            }
            if (s instanceof CubicCurve2D) {
                l = (CubicCurve2D)s;
                if (cur == null || cur.getX() != ((CubicCurve2D)l).getX1() || cur.getY() != ((CubicCurve2D)l).getY1()) {
                    p.moveTo(((CubicCurve2D)l).getX1(), ((CubicCurve2D)l).getY1());
                }
                p.curveTo(((CubicCurve2D)l).getCtrlX1(), ((CubicCurve2D)l).getCtrlY1(), ((CubicCurve2D)l).getCtrlX2(), ((CubicCurve2D)l).getCtrlY2(), ((CubicCurve2D)l).getX2(), ((CubicCurve2D)l).getY2());
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    public static void main(String[] args) {
    }

    private static class PathIteratorToShapeIterator
    implements Iterator<Shape> {
        final PathIterator pi;
        double[] lineTo = new double[6];
        double[] startPos = new double[2];
        double[] from = new double[2];
        int degree = 0;

        PathIteratorToShapeIterator(PathIterator pi) {
            this.pi = pi;
            while (!pi.isDone()) {
                int type = pi.currentSegment(this.lineTo);
                pi.next();
                if (type == 0) {
                    this.startPos[0] = this.from[0] = this.lineTo[0];
                    this.startPos[1] = this.from[1] = this.lineTo[1];
                }
                if (type == 4) {
                    type = 1;
                    this.lineTo[0] = this.startPos[0];
                    this.lineTo[1] = this.startPos[1];
                }
                if (type < 1 || type > 3) continue;
                this.degree = type;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.degree > 0;
        }

        @Override
        public Shape next() {
            if (this.degree == 0) {
                return null;
            }
            Shape res = null;
            if (this.degree == 1) {
                res = new Line2D.Double(this.from[0], this.from[1], this.lineTo[0], this.lineTo[1]);
            } else if (this.degree == 2) {
                res = new QuadCurve2D.Double(this.from[0], this.from[1], this.lineTo[0], this.lineTo[1], this.lineTo[2], this.lineTo[3]);
            } else if (this.degree == 3) {
                res = new CubicCurve2D.Double(this.from[0], this.from[1], this.lineTo[0], this.lineTo[1], this.lineTo[2], this.lineTo[3], this.lineTo[4], this.lineTo[5]);
            } else {
                throw new IllegalArgumentException();
            }
            this.degree = 0;
            this.from[0] = this.lineTo[0];
            this.from[1] = this.lineTo[1];
            while (!this.pi.isDone()) {
                int type = this.pi.currentSegment(this.lineTo);
                this.pi.next();
                if (type == 0) {
                    this.startPos[0] = this.from[0] = this.lineTo[0];
                    this.startPos[1] = this.from[1] = this.lineTo[1];
                }
                if (type == 4) {
                    type = 1;
                    this.lineTo[0] = this.startPos[0];
                    this.lineTo[1] = this.startPos[1];
                }
                if (type < 1 || type > 3) continue;
                this.degree = type;
                break;
            }
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

