/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.algorithm2;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.g2d.routing.Constants;
import org.simantics.g2d.routing.IConnection;
import org.simantics.g2d.routing.IRouter2;
import org.simantics.g2d.routing.algorithm2.LocalRouter;

public class Router3
implements IRouter2 {
    LocalRouter localRouter;
    double bestCost;
    Path2D[] bestPaths;
    static final AffineTransform identity = new AffineTransform();
    static final AffineTransform IDENTITY = new AffineTransform();

    public Router3(boolean roundCorners) {
        this.localRouter = new LocalRouter(roundCorners);
    }

    private Path2D route(double beginX, double beginY, int sDir, Rectangle2D beginObstacle, double endX, double endY, int tDir, Rectangle2D endObstacle) {
        this.localRouter.sx = beginX;
        this.localRouter.sy = beginY;
        if (beginObstacle == null) {
            this.localRouter.aMinX = beginX;
            this.localRouter.aMinY = beginY;
            this.localRouter.aMaxX = beginX;
            this.localRouter.aMaxY = beginY;
        } else {
            this.localRouter.aMinX = beginObstacle.getMinX();
            this.localRouter.aMinY = beginObstacle.getMinY();
            this.localRouter.aMaxX = beginObstacle.getMaxX();
            this.localRouter.aMaxY = beginObstacle.getMaxY();
        }
        this.localRouter.sourceDirection = sDir;
        this.localRouter.tx = endX;
        this.localRouter.ty = endY;
        if (endObstacle == null) {
            this.localRouter.bMinX = endX;
            this.localRouter.bMinY = endY;
            this.localRouter.bMaxX = endX;
            this.localRouter.bMaxY = endY;
        } else {
            this.localRouter.bMinX = endObstacle.getMinX();
            this.localRouter.bMinY = endObstacle.getMinY();
            this.localRouter.bMaxX = endObstacle.getMaxX();
            this.localRouter.bMaxY = endObstacle.getMaxY();
        }
        this.localRouter.targetDirection = tDir;
        this.localRouter.route();
        return this.localRouter.path;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void route(IConnection connection) {
        Collection<? extends Object> segments = connection.getSegments();
        if (segments.size() == 1) {
            for (Object object : segments) {
                IConnection.Connector begin = connection.getBegin(object);
                IConnection.Connector end = connection.getEnd(object);
                double d = Double.POSITIVE_INFINITY;
                Path2D bestPath = null;
                int[] n5 = Constants.POSSIBLE_DIRECTIONS[begin.allowedDirections];
                int n = n5.length;
                int n2 = 0;
                while (n2 < n) {
                    int sDir = n5[n2];
                    int[] n7 = Constants.POSSIBLE_DIRECTIONS[end.allowedDirections];
                    int n3 = n7.length;
                    int nArray = 0;
                    while (nArray < n3) {
                        int tDir = n7[nArray];
                        Path2D path = this.route(begin.x, begin.y, sDir, begin.parentObstacle, end.x, end.y, tDir, end.parentObstacle);
                        double length = Router3.pathCost(path);
                        if (length < d) {
                            d = length;
                            bestPath = this.localRouter.path;
                        }
                        ++nArray;
                    }
                    ++n2;
                }
                if (bestPath == null) continue;
                connection.setPath(object, bestPath);
            }
        } else {
            void var7_14;
            SegmentInfo[] segmentInfoArray = new SegmentInfo[segments.size()];
            TObjectIntHashMap connectorIds = new TObjectIntHashMap();
            int sId = 0;
            int cId = 0;
            for (Object object : segments) {
                IConnection.Connector begin = connection.getBegin(object);
                IConnection.Connector end = connection.getEnd(object);
                SegmentInfo sInfo = new SegmentInfo();
                sInfo.segment = object;
                if (connectorIds.contains((Object)begin)) {
                    sInfo.begin = connectorIds.get((Object)begin);
                } else {
                    sInfo.begin = cId;
                    connectorIds.put((Object)begin, cId);
                    cId += 4;
                }
                if (connectorIds.contains((Object)end)) {
                    sInfo.end = connectorIds.get((Object)end);
                } else {
                    sInfo.end = cId;
                    connectorIds.put((Object)end, cId);
                    cId += 4;
                }
                int[] nArray = Constants.POSSIBLE_DIRECTIONS[begin.allowedDirections];
                int n = nArray.length;
                int n4 = 0;
                while (n4 < n) {
                    int sDir = nArray[n4];
                    int[] nArray2 = Constants.POSSIBLE_DIRECTIONS[end.allowedDirections];
                    int n5 = nArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int tDir = nArray2[n6];
                        Path2D path = this.route(begin.x, begin.y, sDir, begin.parentObstacle, end.x, end.y, tDir, end.parentObstacle);
                        sInfo.candidates.add(new SegmentCandidate(path, Router3.pathCost(path), sDir, tDir));
                        ++n6;
                    }
                    ++n4;
                }
                segmentInfoArray[sId++] = sInfo;
            }
            this.bestCost = Double.POSITIVE_INFINITY;
            this.bestPaths = new Path2D[sId];
            this.findBestCandidate(0, segmentInfoArray, new Path2D[sId], new int[cId], 0.0);
            boolean bl = false;
            while (var7_14 < sId) {
                connection.setPath(segmentInfoArray[var7_14].segment, this.bestPaths[var7_14]);
                ++var7_14;
            }
        }
    }

    void findBestCandidate(int seg, SegmentInfo[] sInfos, Path2D[] chosen, int[] dirCounts, double cost) {
        if (cost >= this.bestCost) {
            return;
        }
        if (seg < sInfos.length) {
            for (SegmentCandidate sCand : sInfos[seg].candidates) {
                chosen[seg] = sCand.path;
                int sId = sInfos[seg].begin + sCand.sDir;
                int tId = sInfos[seg].end + sCand.tDir;
                double nCost = cost + sCand.localCost;
                int n = sId;
                dirCounts[n] = dirCounts[n] + 1;
                if (dirCounts[n] > 1) {
                    nCost += 10.0;
                }
                nCost += 2.0 * (double)(dirCounts[sId ^ 1] + dirCounts[sId ^ 3]);
                int n2 = tId;
                dirCounts[n2] = dirCounts[n2] + 1;
                if (dirCounts[n2] > 1) {
                    nCost += 10.0;
                }
                nCost += 2.0 * (double)(dirCounts[tId ^ 1] + dirCounts[tId ^ 3]);
                int i = 0;
                while (i < seg) {
                    nCost += 10.0 * (double)Router3.intersections(chosen[i], sCand.path);
                    ++i;
                }
                this.findBestCandidate(seg + 1, sInfos, chosen, dirCounts, nCost);
                int n3 = sId;
                dirCounts[n3] = dirCounts[n3] - 1;
                int n4 = tId;
                dirCounts[n4] = dirCounts[n4] - 1;
            }
        } else {
            this.bestCost = cost;
            System.arraycopy(chosen, 0, this.bestPaths, 0, seg);
        }
    }

    static int intersections(Path2D path1, Path2D path2) {
        int count = 0;
        PathIterator it1 = path1.getPathIterator(identity);
        double begin1X = 0.0;
        double begin1Y = 0.0;
        double end1X = 0.0;
        double end1Y = 0.0;
        double begin2X = 0.0;
        double begin2Y = 0.0;
        double end2X = 0.0;
        double end2Y = 0.0;
        double[] temp = new double[6];
        while (!it1.isDone()) {
            int t1 = it1.currentSegment(temp);
            if (t1 == 0) {
                end1X = temp[0];
                end1Y = temp[1];
            } else if (t1 == 1) {
                double max1Y;
                double min1Y;
                double max1X;
                double min1X;
                begin1X = end1X;
                begin1Y = end1Y;
                end1X = temp[0];
                end1Y = temp[1];
                if (begin1X < end1X) {
                    min1X = begin1X;
                    max1X = end1X;
                } else {
                    max1X = begin1X;
                    min1X = end1X;
                }
                if (begin1Y < end1Y) {
                    min1Y = begin1Y;
                    max1Y = end1Y;
                } else {
                    max1Y = begin1Y;
                    min1Y = end1Y;
                }
                PathIterator it2 = path2.getPathIterator(identity);
                while (!it2.isDone()) {
                    int t2 = it2.currentSegment(temp);
                    if (t2 == 0) {
                        end2X = temp[0];
                        end2Y = temp[1];
                    } else if (t2 == 1) {
                        double max2Y;
                        double min2Y;
                        double max2X;
                        double min2X;
                        begin2X = end2X;
                        begin2Y = end2Y;
                        end2X = temp[0];
                        end2Y = temp[1];
                        if (begin2X < end2X) {
                            min2X = begin2X;
                            max2X = end2X;
                        } else {
                            max2X = begin2X;
                            min2X = end2X;
                        }
                        if (begin2Y < end2Y) {
                            min2Y = begin2Y;
                            max2Y = end2Y;
                        } else {
                            max2Y = begin2Y;
                            min2Y = end2Y;
                        }
                        if ((min1X < min2X && max2X < max1X || min2X < min1X && max1X < max2X) && (min1Y < min2Y && max2Y < max1Y || min2Y < min1Y && max1Y < max2Y)) {
                            ++count;
                        }
                    }
                    it2.next();
                }
            }
            it1.next();
        }
        return count;
    }

    static double pathCost(Path2D path) {
        double length = 0.0;
        PathIterator it = path.getPathIterator(IDENTITY);
        double[] temp = new double[6];
        double x = 0.0;
        double y = 0.0;
        double bendCount = 0.0;
        while (!it.isDone()) {
            bendCount += 1.0;
            if (it.currentSegment(temp) != 0) {
                length += Math.abs(x - temp[0] + y - temp[1]);
            }
            x = temp[0];
            y = temp[1];
            it.next();
        }
        return bendCount - 1.0 / length;
    }

    static class SegmentCandidate {
        Path2D path;
        double localCost;
        int sDir;
        int tDir;

        public SegmentCandidate(Path2D path, double localCost, int sDir, int tDir) {
            this.path = path;
            this.localCost = localCost;
            this.sDir = sDir;
            this.tDir = tDir;
        }
    }

    static class SegmentInfo {
        Object segment;
        int begin;
        int end;
        ArrayList<SegmentCandidate> candidates = new ArrayList(4);

        SegmentInfo() {
        }
    }
}

