/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Set;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.CanvasGrab;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.RulerPainter;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.g2d.nodes.TransformNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class PanZoomRotateHandler
extends AbstractCanvasParticipant {
    public static final IHintContext.Key KEY_ADAPT_VIEWPORT_TO_RESIZED_CONTROL = new IHintContext.KeyOf(Boolean.class, "ADAPT_VIEWPORT_TO_RESIZED_CONTROL");
    public static final IHintContext.Key KEY_ZOOM_OUT_LIMIT = new IHintContext.KeyOf(Double.class, "ZOOM_OUT_LIMIT");
    public static final IHintContext.Key KEY_ZOOM_IN_LIMIT = new IHintContext.KeyOf(Double.class, "ZOOM_IN_LIMIT");
    public static final IHintContext.Key KEY_DISABLE_ZOOM = new IHintContext.KeyOf(Boolean.class, "DISABLE_ZOOM");
    public static final IHintContext.Key KEY_DISABLE_PAN = new IHintContext.KeyOf(Boolean.class, "DISABLE_PAN");
    @DependencyReflection.Dependency
    CanvasGrab grab;
    @DependencyReflection.Dependency
    TransformUtil util;
    @DependencyReflection.Dependency
    KeyUtil keys;
    @DependencyReflection.Reference
    Selection selection;
    @DependencyReflection.Reference
    CanvasBoundsParticipant bounds;
    Point2D centerPointControl;
    Point2D centerPointCanvas;
    Point2D controlSize;
    final Boolean navigationEnabled;
    protected NavigationNode node = null;
    protected G2DParentNode oldRoot = null;
    NavigationNode.TransformListener transformListener = new NavigationNode.TransformListener(){

        public void transformChanged(final AffineTransform transform) {
            ThreadUtils.asyncExec((IThreadWorkQueue)PanZoomRotateHandler.this.getContext().getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (PanZoomRotateHandler.this.isRemoved()) {
                        return;
                    }
                    PanZoomRotateHandler.this.setHint(Hints.KEY_CANVAS_TRANSFORM, transform);
                }
            });
        }
    };
    IHintListener hintListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (PanZoomRotateHandler.this.node != null) {
                if (key == Hints.KEY_DISABLE_PAINTING) {
                    boolean visible;
                    boolean bl = visible = !Boolean.TRUE.equals(newValue);
                    if (visible != PanZoomRotateHandler.this.node.isVisible()) {
                        PanZoomRotateHandler.this.node.setVisible(Boolean.valueOf(visible));
                    }
                } else if (key == KEY_ADAPT_VIEWPORT_TO_RESIZED_CONTROL) {
                    boolean noKeepZoom = Boolean.FALSE.equals(newValue);
                    if (noKeepZoom == PanZoomRotateHandler.this.node.getAdaptViewportToResizedControl()) {
                        PanZoomRotateHandler.this.node.setAdaptViewportToResizedControl(Boolean.valueOf(!noKeepZoom));
                    }
                } else if (key == KEY_ZOOM_OUT_LIMIT) {
                    PanZoomRotateHandler.this.node.setZoomOutLimit((Double)newValue);
                } else if (key == KEY_ZOOM_IN_LIMIT) {
                    PanZoomRotateHandler.this.node.setZoomInLimit((Double)newValue);
                } else if (key == KEY_DISABLE_ZOOM) {
                    PanZoomRotateHandler.this.node.setZoomEnabled(Boolean.valueOf(!Boolean.TRUE.equals(PanZoomRotateHandler.this.getHint(KEY_DISABLE_ZOOM))));
                }
            }
        }
    };
    public static final IHintContext.Key KEY_TRANSLATE_AMOUNT = new IHintContext.KeyOf(Integer.class);
    public static final IHintContext.Key KEY_ZOOM_AMOUNT = new IHintContext.KeyOf(Double.class);
    public static final IHintContext.Key KEY_ROTATE_AMOUNT = new IHintContext.KeyOf(Double.class);
    public static final int DEFAULT_KEYBOARD_TRANSLATE_AMOUNT = 30;
    public static final double DEFAULT_KEYBOARD_ZOOM_AMOUNT = 1.2;
    public static final double DEFAULT_KEYBOARD_ROTATE_AMOUNT = 0.1;
    public static final MarginUtils.Margins DEFAULT_ZOOM_TO_FIT_MARGINS = RulerPainter.RULER_MARINGS2;
    public static final MarginUtils.Margins DEFAULT_ZOOM_TO_FIT_MARGINS_NO_RULER = MarginUtils.MARGINS2;
    public static final int ROTATE_GRAB_ID = -666;

    public PanZoomRotateHandler() {
        this(true);
    }

    public PanZoomRotateHandler(boolean navigationEnabled) {
        this.navigationEnabled = navigationEnabled;
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        ctx.getDefaultHintContext().addKeyHintListener(Hints.KEY_DISABLE_PAINTING, this.hintListener);
        ctx.getDefaultHintContext().addKeyHintListener(KEY_ADAPT_VIEWPORT_TO_RESIZED_CONTROL, this.hintListener);
        ctx.getDefaultHintContext().addKeyHintListener(KEY_ZOOM_OUT_LIMIT, this.hintListener);
        ctx.getDefaultHintContext().addKeyHintListener(KEY_ZOOM_IN_LIMIT, this.hintListener);
        ctx.getDefaultHintContext().addKeyHintListener(KEY_DISABLE_ZOOM, this.hintListener);
        ctx.getDefaultHintContext().addKeyHintListener(KEY_DISABLE_PAN, this.hintListener);
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        ctx.getDefaultHintContext().removeKeyHintListener(KEY_ZOOM_IN_LIMIT, this.hintListener);
        ctx.getDefaultHintContext().removeKeyHintListener(KEY_ZOOM_OUT_LIMIT, this.hintListener);
        ctx.getDefaultHintContext().removeKeyHintListener(KEY_ADAPT_VIEWPORT_TO_RESIZED_CONTROL, this.hintListener);
        ctx.getDefaultHintContext().removeKeyHintListener(Hints.KEY_DISABLE_PAINTING, this.hintListener);
        ctx.getDefaultHintContext().removeKeyHintListener(KEY_DISABLE_ZOOM, this.hintListener);
        ctx.getDefaultHintContext().removeKeyHintListener(KEY_DISABLE_PAN, this.hintListener);
        super.removedFromContext(ctx);
    }

    protected Class<? extends NavigationNode> getNavigationNodeClass() {
        return NavigationNode.class;
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        INode oldnav = NodeUtil.getRootNode((IG2DNode)parent).getNode("navigation");
        this.node = oldnav != null ? (NavigationNode)oldnav.appendParent("navigation", this.getNavigationNodeClass()) : (NavigationNode)parent.addNode("navigation", this.getNavigationNodeClass());
        this.node.setLookupId("navigation");
        this.node.setZIndex(0);
        this.node.setTransformListener(this.transformListener);
        this.node.setNavigationEnabled(this.navigationEnabled);
        this.node.setZoomEnabled(Boolean.valueOf(!Boolean.TRUE.equals(this.getHint(KEY_DISABLE_ZOOM))));
        this.node.setAdaptViewportToResizedControl(Boolean.valueOf(!Boolean.FALSE.equals(this.getHint(KEY_ADAPT_VIEWPORT_TO_RESIZED_CONTROL))));
        Double z = (Double)this.getHint(KEY_ZOOM_AMOUNT);
        if (z != null) {
            this.util.setTransform(AffineTransform.getScaleInstance(z, z));
            this.node.setTransform(AffineTransform.getScaleInstance(z, z));
        }
        boolean visible = !Boolean.TRUE.equals(this.getHint(Hints.KEY_DISABLE_PAINTING));
        this.node.setVisible(Boolean.valueOf(visible));
        this.oldRoot = this.getContext().getCanvasNode();
        this.getContext().setCanvasNode((G2DParentNode)this.node);
    }

    public void update() {
        if (this.bounds != null) {
            Rectangle2D vp = this.bounds.getControlBounds();
            this.controlSize = new Point2D.Double(vp.getMaxX(), vp.getMaxY());
            this.centerPointControl = new Point2D.Double(vp.getCenterX(), vp.getCenterY());
            this.centerPointCanvas = this.util.controlToCanvas(this.centerPointControl, null);
        }
    }

    public TransformNode getNode() {
        return this.node;
    }

    public void setTransform(AffineTransform transform) {
        this.getNode().setTransform(transform);
        this.transformListener.transformChanged(transform);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.node.remove();
        this.node = null;
        this.getContext().setCanvasNode(this.oldRoot);
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleEvent(CommandEvent e) {
        double scaleFactor;
        boolean zoomDisabled;
        this.assertDependencies();
        this.update();
        Command c = e.command;
        boolean panDisabled = Boolean.TRUE.equals(this.getHint(KEY_DISABLE_PAN));
        boolean bl = zoomDisabled = Boolean.TRUE.equals(this.getHint(KEY_DISABLE_ZOOM));
        if (Commands.PAN_LEFT.equals((Object)c) && !panDisabled) {
            this.util.translateWithControlCoordinates(new Point2D.Double(this.getTranslateAmount(), 0.0));
            return true;
        }
        if (Commands.PAN_RIGHT.equals((Object)c) && !panDisabled) {
            this.util.translateWithControlCoordinates(new Point2D.Double(-this.getTranslateAmount(), 0.0));
            return true;
        }
        if (Commands.PAN_UP.equals((Object)c) && !panDisabled) {
            this.util.translateWithControlCoordinates(new Point2D.Double(0.0, this.getTranslateAmount()));
            return true;
        }
        if (Commands.PAN_DOWN.equals((Object)c) && !panDisabled) {
            this.util.translateWithControlCoordinates(new Point2D.Double(0.0, -this.getTranslateAmount()));
            return true;
        }
        if (Commands.ZOOM_IN.equals((Object)c) && !zoomDisabled) {
            if (this.centerPointControl == null) {
                return false;
            }
            scaleFactor = this.getZoomAmount();
            scaleFactor = this.limitScaleFactor(scaleFactor);
            this.util.zoomAroundControlPoint(scaleFactor, this.centerPointControl);
        }
        if (Commands.ZOOM_OUT.equals((Object)c) && !zoomDisabled) {
            if (this.centerPointControl == null) {
                return false;
            }
            scaleFactor = 1.0 / this.getZoomAmount();
            scaleFactor = this.limitScaleFactor(scaleFactor);
            this.util.zoomAroundControlPoint(scaleFactor, this.centerPointControl);
        }
        if (Commands.ROTATE_CANVAS_CCW.equals((Object)c)) {
            if (this.centerPointCanvas == null) {
                return false;
            }
            this.util.rotate(this.centerPointCanvas, -this.getRotateAmount());
            this.setDirty();
            return true;
        }
        if (Commands.ROTATE_CANVAS_CW.equals((Object)c)) {
            if (this.centerPointCanvas == null) {
                return false;
            }
            this.util.rotate(this.centerPointCanvas, this.getRotateAmount());
            this.setDirty();
            return true;
        }
        if (Commands.ROTATE_CANVAS_CCW_GRAB.equals((Object)c)) {
            if (this.centerPointCanvas == null) {
                return false;
            }
            this.util.rotate(this.centerPointCanvas, -this.getRotateAmount());
            this.grab.grabCanvas(-666, this.centerPointCanvas);
            this.grab.grabCanvas(-667, this.centerPointCanvas);
            this.setDirty();
            return true;
        }
        if (Commands.ROTATE_CANVAS_CW_GRAB.equals((Object)c)) {
            if (this.centerPointCanvas == null) {
                return false;
            }
            this.util.rotate(this.centerPointCanvas, this.getRotateAmount());
            this.grab.grabCanvas(-666, this.centerPointCanvas);
            this.grab.grabCanvas(-667, this.centerPointCanvas);
            this.setDirty();
            return true;
        }
        if (Commands.ROTATE_CANVAS_CCW_RELEASE.equals((Object)c)) {
            if (this.centerPointCanvas == null) {
                return false;
            }
            this.grab.releaseCanvas(-666);
            this.grab.releaseCanvas(-667);
            this.setDirty();
            return true;
        }
        if (Commands.ROTATE_CANVAS_CW_RELEASE.equals((Object)c)) {
            if (this.centerPointCanvas == null) {
                return false;
            }
            this.grab.releaseCanvas(-666);
            this.grab.releaseCanvas(-667);
            this.setDirty();
            return true;
        }
        if (Commands.ENABLE_PAINTING.equals((Object)c)) {
            Boolean t = (Boolean)this.getHint(Hints.KEY_DISABLE_PAINTING);
            this.removeHint(Hints.KEY_DISABLE_PAINTING);
            boolean processed = Boolean.TRUE.equals(t);
            if (processed) {
                this.setDirty();
            }
            return processed;
        }
        if (Commands.ZOOM_TO_FIT.equals((Object)c) && !zoomDisabled) {
            boolean result = this.zoomToFit();
            if (!result) {
                result = this.zoomToPage();
            }
            return result;
        }
        if (Commands.ZOOM_TO_SELECTION.equals((Object)c) && !zoomDisabled && this.selection != null) {
            if (this.controlSize == null) {
                return false;
            }
            IDiagram d = (IDiagram)this.getHint(DiagramHints.KEY_DIAGRAM);
            if (d == null) {
                return false;
            }
            Set<IElement> selections = this.selection.getAllSelections();
            Rectangle2D diagramRect = ElementUtils.getSurroundingElementBoundsOnDiagram(selections);
            if (diagramRect == null) {
                return false;
            }
            if (diagramRect.getWidth() <= 0.0 && diagramRect.getHeight() <= 0.0) {
                return false;
            }
            if (diagramRect.getWidth() <= 0.0) {
                GeometryUtils.expandRectangle((Rectangle2D)diagramRect, (double)0.0, (double)0.0, (double)1.0, (double)1.0);
            }
            if (diagramRect.getHeight() <= 0.0) {
                GeometryUtils.expandRectangle((Rectangle2D)diagramRect, (double)1.0, (double)1.0, (double)0.0, (double)0.0);
            }
            Rectangle2D.Double controlArea = new Rectangle2D.Double(0.0, 0.0, this.controlSize.getX(), this.controlSize.getY());
            this.util.fitArea(controlArea, diagramRect, PanZoomRotateHandler.getZoomToFitMargins((IHintObservable)this.getHintStack()));
            return true;
        }
        if (Commands.ZOOM_TO_PAGE.equals((Object)c) && !zoomDisabled) {
            return this.zoomToPage();
        }
        return false;
    }

    private boolean zoomToFit() {
        if (this.controlSize == null) {
            return false;
        }
        IDiagram d = (IDiagram)this.getHint(DiagramHints.KEY_DIAGRAM);
        if (d == null) {
            return false;
        }
        Rectangle2D diagramRect = DiagramUtils.getContentRect(d);
        if (diagramRect == null) {
            return false;
        }
        if (diagramRect.isEmpty()) {
            return false;
        }
        Rectangle2D.Double controlArea = new Rectangle2D.Double(0.0, 0.0, this.controlSize.getX(), this.controlSize.getY());
        this.util.fitArea(controlArea, diagramRect, PanZoomRotateHandler.getZoomToFitMargins((IHintObservable)this.getHintStack()));
        return true;
    }

    private boolean zoomToPage() {
        if (this.controlSize == null) {
            return false;
        }
        PageDesc desc = (PageDesc)this.getHint(Hints.KEY_PAGE_DESC);
        if (desc == null) {
            return false;
        }
        if (desc.isInfinite()) {
            return false;
        }
        Rectangle2D.Double diagramRect = new Rectangle2D.Double();
        desc.getPageRectangle((Rectangle2D)diagramRect);
        if (((RectangularShape)diagramRect).isEmpty()) {
            return false;
        }
        Rectangle2D.Double controlArea = new Rectangle2D.Double(0.0, 0.0, this.controlSize.getX(), this.controlSize.getY());
        this.util.fitArea(controlArea, diagramRect, PanZoomRotateHandler.getZoomToFitMargins((IHintObservable)this.getHintStack()));
        return true;
    }

    public double getTranslateAmount() {
        Integer h = (Integer)this.getHint(KEY_TRANSLATE_AMOUNT);
        if (h == null) {
            return 30.0;
        }
        return h.intValue();
    }

    public double getZoomAmount() {
        Integer h = (Integer)this.getHint(KEY_TRANSLATE_AMOUNT);
        if (h == null) {
            return 1.2;
        }
        return h.intValue();
    }

    public double getRotateAmount() {
        Integer h = (Integer)this.getHint(KEY_ROTATE_AMOUNT);
        if (h == null) {
            return 0.1;
        }
        return h.intValue();
    }

    public double limitScaleFactor(double scaleFactor) {
        Double inLimit = (Double)this.getHint(KEY_ZOOM_IN_LIMIT);
        Double outLimit = (Double)this.getHint(KEY_ZOOM_OUT_LIMIT);
        if (inLimit == null && scaleFactor < 1.0) {
            return scaleFactor;
        }
        if (outLimit == null && scaleFactor > 1.0) {
            return scaleFactor;
        }
        AffineTransform view = this.util.getTransform();
        double currentScale = org.simantics.g2d.utils.GeometryUtils.getScale(view) * 100.0;
        double newScale = currentScale * scaleFactor;
        if (inLimit != null && newScale > currentScale && newScale > inLimit) {
            scaleFactor = currentScale < inLimit ? inLimit / currentScale : 1.0;
        } else if (outLimit != null && newScale < currentScale && newScale < outLimit) {
            scaleFactor = currentScale > outLimit ? outLimit / currentScale : 1.0;
        }
        return scaleFactor;
    }

    public static MarginUtils.Margins getZoomToFitMargins(IHintObservable hints) {
        MarginUtils.Margins h = (MarginUtils.Margins)hints.getHint(DiagramHints.KEY_MARGINS);
        if (h == null) {
            boolean rulerEnabled;
            Boolean b = (Boolean)hints.getHint(RulerPainter.KEY_RULER_ENABLED);
            boolean bl = rulerEnabled = b == null || Boolean.TRUE.equals(b);
            if (rulerEnabled) {
                return DEFAULT_ZOOM_TO_FIT_MARGINS;
            }
            return DEFAULT_ZOOM_TO_FIT_MARGINS_NO_RULER;
        }
        return h;
    }
}

