/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.canvas;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class DiagramPainter
implements SceneGraph {
    public static final IHintContext.Key KEY_VIEWPORT = new IHintContext.KeyOf(AffineTransform.class, "DiagramPainter.VIEWPORT");
    private static final long serialVersionUID = 6500535141363250713L;
    public static final DiagramPainter INSTANCE = new DiagramPainter();
    private static final Color FILM_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.3f);
    private static final IHintContext.Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

    @Override
    public void cleanup(IElement e) {
        ElementUtils.removePossibleNode(e, SG_NODE);
    }

    @Override
    public void init(IElement e, G2DParentNode parent) {
        G2DParentNode node = (G2DParentNode)e.getHint(SG_NODE);
        if (node == null) {
            node = (G2DParentNode)parent.addNode(G2DParentNode.class);
            e.setHint(SG_NODE, node);
        }
        IDiagram d = (IDiagram)e.getHint(DiagramHints.KEY_DIAGRAM);
        Rectangle2D bounds = ElementUtils.getElementBounds(e);
        AffineTransform viewport = (AffineTransform)e.getHint(KEY_VIEWPORT);
        Color bc = ElementUtils.getBorderColor(e);
        Color fc = ElementUtils.getFillColor(e);
        node.removeNodes();
        if (fc != null) {
            ShapeNode fcn = (ShapeNode)node.addNode(ShapeNode.class);
            fcn.setColor((Paint)fc);
            fcn.setFill(true);
            fcn.setShape((Shape)bounds);
        }
        if (bc != null) {
            ShapeNode bcn = (ShapeNode)node.addNode(ShapeNode.class);
            Stroke stroke = (Stroke)e.getHint(ElementHints.KEY_STROKE);
            if (stroke != null) {
                bcn.setStroke(stroke);
            }
            bcn.setScaleStroke(true);
            bcn.setColor((Paint)bc);
            bcn.setShape((Shape)bounds);
        }
        if (d == null) {
            ShapeNode shape = (ShapeNode)node.addNode(ShapeNode.class);
            ShapeNode line1 = (ShapeNode)node.addNode(ShapeNode.class);
            ShapeNode line2 = (ShapeNode)node.addNode(ShapeNode.class);
            shape.setColor((Paint)FILM_COLOR);
            shape.setFill(true);
            shape.setShape((Shape)bounds);
            line1.setColor((Paint)Color.WHITE);
            line1.setShape((Shape)new Line2D.Double(bounds.getMinX(), bounds.getMinX(), bounds.getMaxX(), bounds.getMaxY()));
            line2.setColor((Paint)Color.WHITE);
            line2.setShape((Shape)new Line2D.Double(bounds.getMaxX(), bounds.getMinX(), bounds.getMinX(), bounds.getMaxY()));
        } else if (viewport == null) {
            viewport = new AffineTransform();
        }
    }
}

