/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.button;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.Clickable;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.Stateful;
import org.simantics.g2d.element.handler.Text;
import org.simantics.g2d.element.handler.impl.AbstractClickable;
import org.simantics.g2d.element.handler.impl.AbstractTogglable;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.Resizeable;
import org.simantics.g2d.elementclass.button.ButtonColorProfile;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class ButtonClass {
    public static final ElementClass BUTTON_CLASS = ElementClass.compile(Clickable.INSTANCE, Text.INSTANCE, Resizeable.UNCONSTRICTED, DefaultTransform.INSTANCE, ButtonPaint.INSTANCE, Stateful.ENABLED_BY_DEFAULT);

    static class ButtonPaint
    implements SceneGraph {
        private static final long serialVersionUID = 5484741334876153022L;
        public static final ButtonPaint INSTANCE = new ButtonPaint();
        public static final IHintContext.Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

        ButtonPaint() {
        }

        @Override
        public void cleanup(IElement e) {
            Node node = (Node)e.removeHint(SG_NODE);
            if (node != null) {
                node.remove();
            }
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            ButtonNode node = (ButtonNode)((Object)e.getHint(SG_NODE));
            if (node == null) {
                node = (ButtonNode)((Object)parent.addNode(ButtonNode.class));
                e.setHint(SG_NODE, (Object)node);
                e.addKeyHintListener(ElementHints.KEY_TEXT, (IHintListener)new HintListenerAdapter(){

                    public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                        if (sender instanceof IElement) {
                            ButtonNode node = (ButtonNode)((Object)((IElement)sender).getHint(SG_NODE));
                            node.buttonText = (String)newValue;
                            node.repaint();
                        }
                    }
                });
                e.addKeyHintListener(AbstractClickable.PRESS_STATUS_KEY, (IHintListener)new HintListenerAdapter(){

                    public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                        if (sender instanceof IElement) {
                            ButtonNode node = (ButtonNode)((Object)((IElement)sender).getHint(SG_NODE));
                            node.status = (Clickable.PressStatus)((Object)newValue);
                            node.repaint();
                        }
                    }
                });
            }
            Rectangle2D rect = ElementUtils.getElementBounds(e);
            ButtonColorProfile colors = ButtonColorProfile.DEFAULT;
            double height = rect.getHeight();
            boolean enabled = this.isEnabled(e);
            Clickable.PressStatus status = Clickable.PressStatus.NORMAL;
            Font font = new Font("Tahoma", 0, (int)height - 6);
            Font selFont = new Font("Tahoma", 1, (int)height - 6);
            Text text = e.getElementClass().getAtMostOneItemOfClass(Text.class);
            String buttonText = null;
            if (text != null) {
                buttonText = text.getText(e);
            }
            if (buttonText == null) {
                buttonText = "";
            }
            boolean checked = this.isChecked(e);
            System.out.println("ButtonClass.init " + String.valueOf(e) + " " + String.valueOf((Object)status) + " " + checked);
            node.init(status, rect, enabled, checked, colors, font, selFont, buttonText);
        }

        protected ButtonColorProfile getColorProfile(IElement e) {
            return ButtonColorProfile.DEFAULT;
        }

        public boolean isEnabled(IElement e) {
            Stateful enabled = e.getElementClass().getAtMostOneItemOfClass(Stateful.class);
            if (enabled == null) {
                return true;
            }
            return enabled.isEnabled(e);
        }

        public boolean isChecked(IElement e) {
            Boolean b = (Boolean)e.getHint(AbstractTogglable.TOGGLE_KEY);
            if (b == null) {
                return false;
            }
            return b;
        }

        public static class ButtonNode
        extends G2DNode {
            private static final long serialVersionUID = 2291569851866542945L;
            Clickable.PressStatus status = null;
            Rectangle2D rect = null;
            Boolean enabled = null;
            Boolean checked = null;
            ButtonColorProfile colors = null;
            Font font = null;
            Font selFont = null;
            String buttonText = null;

            public Rectangle2D getBoundsInLocal() {
                return this.rect;
            }

            @INode.SyncField(value={"pressStatus"})
            void setPressStatus(Clickable.PressStatus pressStatus) {
                this.status = pressStatus;
            }

            public void init(Clickable.PressStatus status, Rectangle2D rect, boolean enabled, boolean checked, ButtonColorProfile colors, Font font, Font selFont, String buttonText) {
                this.status = status;
                this.rect = rect;
                this.enabled = enabled;
                this.checked = checked;
                this.colors = colors;
                this.font = font;
                this.selFont = selFont;
                this.buttonText = buttonText;
            }

            public void render(Graphics2D g) {
                AffineTransform ot = g.getTransform();
                switch (this.status) {
                    case NORMAL: {
                        this.drawNormal(g, this.rect, this.enabled, this.checked, this.colors, this.font, this.selFont, this.buttonText);
                        break;
                    }
                    case HELD: {
                        this.drawHeld(g, this.rect, this.enabled, this.colors, this.font, this.selFont, this.buttonText);
                        break;
                    }
                    case PRESSED: {
                        this.drawPressed(g, this.rect, this.enabled, this.colors, this.font, this.selFont, this.buttonText);
                        break;
                    }
                    case HOVER: {
                        this.drawHover(g, this.rect, this.enabled, this.colors, this.font, this.selFont, this.buttonText);
                    }
                }
                g.setTransform(ot);
            }

            protected void drawNormal(Graphics2D g, Rectangle2D rect, boolean enabled, boolean checked, ButtonColorProfile colors, Font font, Font selectedFont, String text) {
                if (checked) {
                    this.drawPressed(g, rect, enabled, colors, font, selectedFont, text);
                    return;
                }
                g.translate(rect.getX(), rect.getY());
                double width = rect.getWidth();
                double height = rect.getHeight();
                g.setColor(colors.BACKGROUND);
                g.fill(new Rectangle2D.Double(0.0, 0.0, width - 1.0, height - 1.0));
                g.setColor(colors.BORDER1);
                Line2D.Double line = new Line2D.Double();
                ((Line2D)line).setLine(0.0, 0.0, width - 1.0, 0.0);
                g.draw(line);
                ((Line2D)line).setLine(0.0, 0.0, 0.0, height - 1.0);
                g.draw(line);
                g.setColor(colors.BORDER2);
                ((Line2D)line).setLine(1.0, height - 2.0, width - 2.0, height - 2.0);
                g.draw(line);
                ((Line2D)line).setLine(width - 2.0, height - 2.0, width - 2.0, 1.0);
                g.draw(line);
                g.setColor(colors.BORDER3);
                ((Line2D)line).setLine(0.0, height - 1.0, width - 1.0, height - 1.0);
                g.draw(line);
                ((Line2D)line).setLine(width - 1.0, height - 1.0, width - 1.0, 0.0);
                g.draw(line);
                if (enabled) {
                    g.setColor(colors.TEXT_BLACK);
                    FontMetrics fm = g.getFontMetrics(font);
                    Rectangle2D.Double clipRect = new Rectangle2D.Double(2.0, 2.0, width - 4.0, height - 4.0);
                    g.clip(clipRect);
                    g.setFont(font);
                    Rectangle2D stringRect = fm.getStringBounds(text, g);
                    float x = (float)((width - 4.0) / 2.0) - (float)stringRect.getWidth() / 2.0f;
                    g.drawString(text, x, (float)height - 6.0f);
                } else {
                    Rectangle2D.Double clipRect = new Rectangle2D.Double(2.0, 2.0, width - 4.0, height - 4.0);
                    g.clip(clipRect);
                    g.setFont(selectedFont);
                    FontMetrics fm = g.getFontMetrics(selectedFont);
                    Rectangle2D stringRect = fm.getStringBounds(text, g);
                    float x = (float)((width - 4.0) / 2.0) - (float)stringRect.getWidth() / 2.0f;
                    g.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    g.setColor(colors.TEXT_WHITE);
                    g.drawString(text, x + 1.0f, (float)height - 6.0f + 1.0f);
                    g.setColor(colors.TEXT_BLACK);
                    g.drawString(text, x, (float)height - 6.0f);
                }
            }

            protected void drawHeld(Graphics2D g, Rectangle2D rect, boolean enabled, ButtonColorProfile colors, Font font, Font selectedFont, String text) {
                g.translate(rect.getX(), rect.getY());
                double width = rect.getWidth();
                double height = rect.getHeight();
                g.setColor(colors.BACKGROUND);
                g.fill(new Rectangle2D.Double(0.0, 0.0, width - 1.0, height - 1.0));
                Line2D.Double line = new Line2D.Double();
                g.setColor(colors.BORDER3);
                ((Line2D)line).setLine(0.0, 0.0, width - 2.0, 0.0);
                g.draw(line);
                ((Line2D)line).setLine(0.0, 0.0, 0.0, height - 2.0);
                g.draw(line);
                g.setColor(colors.BORDER2);
                ((Line2D)line).setLine(1.0, 1.0, width - 3.0, 1.0);
                g.draw(line);
                ((Line2D)line).setLine(1.0, 1.0, 1.0, height - 3.0);
                g.draw(line);
                g.setColor(colors.BORDER1);
                ((Line2D)line).setLine(0.0, height - 1.0, width - 1.0, height - 1.0);
                g.draw(line);
                ((Line2D)line).setLine(width - 1.0, height - 1.0, width - 1.0, 0.0);
                g.draw(line);
                g.setColor(colors.TEXT_BLACK);
                FontMetrics fm = g.getFontMetrics(font);
                Rectangle2D.Double clipRect = new Rectangle2D.Double(2.0, 2.0, width - 4.0, height - 4.0);
                g.clip(clipRect);
                g.setFont(font);
                Rectangle2D stringRect = fm.getStringBounds(text, g);
                float x = (float)((width - 4.0) / 2.0) - (float)stringRect.getWidth() / 2.0f;
                g.drawString(text, x + 1.0f, (float)height - 6.0f + 1.0f);
            }

            protected void drawPressed(Graphics2D g, Rectangle2D rect, boolean enabled, ButtonColorProfile colors, Font font, Font selectedFont, String text) {
                g.translate(rect.getX(), rect.getY());
                double width = rect.getWidth();
                double height = rect.getHeight();
                g.setColor(colors.SELECTEDBACKGROUND);
                g.fill(new Rectangle2D.Double(0.0, 0.0, width - 1.0, height - 1.0));
                Line2D.Double line = new Line2D.Double();
                g.setColor(colors.BORDER3);
                ((Line2D)line).setLine(0.0, 0.0, width - 2.0, 0.0);
                g.draw(line);
                ((Line2D)line).setLine(0.0, 0.0, 0.0, height - 2.0);
                g.draw(line);
                g.setColor(colors.BORDER2);
                ((Line2D)line).setLine(1.0, 1.0, width - 3.0, 1.0);
                g.draw(line);
                ((Line2D)line).setLine(1.0, 1.0, 1.0, height - 3.0);
                g.draw(line);
                g.setColor(colors.BORDER1);
                ((Line2D)line).setLine(0.0, height - 1.0, width - 1.0, height - 1.0);
                g.draw(line);
                ((Line2D)line).setLine(width - 1.0, height - 1.0, width - 1.0, 0.0);
                g.draw(line);
                if (enabled) {
                    g.setColor(colors.TEXT_BLACK);
                    FontMetrics fm = g.getFontMetrics(font);
                    Rectangle2D.Double clipRect = new Rectangle2D.Double(2.0, 2.0, width - 4.0, height - 4.0);
                    g.clip(clipRect);
                    g.setFont(font);
                    Rectangle2D stringRect = fm.getStringBounds(text, g);
                    float x = (float)((width - 4.0) / 2.0) - (float)stringRect.getWidth() / 2.0f;
                    g.drawString(text, x + 1.0f, (float)height - 6.0f + 1.0f);
                } else {
                    Rectangle2D.Double clipRect = new Rectangle2D.Double(2.0, 2.0, width - 4.0, height - 4.0);
                    g.clip(clipRect);
                    g.setFont(selectedFont);
                    FontMetrics fm = g.getFontMetrics(selectedFont);
                    Rectangle2D stringRect = fm.getStringBounds(text, g);
                    float x = (float)((width - 4.0) / 2.0) - (float)stringRect.getWidth() / 2.0f;
                    g.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    g.setColor(colors.TEXT_WHITE);
                    g.drawString(text, x + 2.0f, (float)height - 6.0f + 2.0f);
                    g.setColor(colors.TEXT_BLACK);
                    g.drawString(text, x + 1.0f, (float)height - 6.0f + 1.0f);
                }
            }

            protected void drawHover(Graphics2D g, Rectangle2D rect, boolean enabled, ButtonColorProfile colors, Font font, Font selectedFont, String text) {
                g.translate(rect.getX(), rect.getY());
                double width = rect.getWidth();
                double height = rect.getHeight();
                g.setColor(colors.HOVERBACKGROUND);
                g.fill(new Rectangle2D.Double(0.0, 0.0, width - 1.0, height - 1.0));
                g.setColor(colors.BORDER1);
                Line2D.Double line = new Line2D.Double();
                ((Line2D)line).setLine(0.0, 0.0, width - 1.0, 0.0);
                g.draw(line);
                ((Line2D)line).setLine(0.0, 0.0, 0.0, height - 1.0);
                g.draw(line);
                g.setColor(colors.BORDER2);
                ((Line2D)line).setLine(1.0, height - 2.0, width - 2.0, height - 2.0);
                g.draw(line);
                ((Line2D)line).setLine(width - 2.0, height - 2.0, width - 2.0, 1.0);
                g.draw(line);
                g.setColor(colors.BORDER3);
                ((Line2D)line).setLine(0.0, height - 1.0, width - 1.0, height - 1.0);
                g.draw(line);
                ((Line2D)line).setLine(width - 1.0, height - 1.0, width - 1.0, 0.0);
                g.draw(line);
                if (enabled) {
                    g.setColor(colors.TEXT_BLACK);
                    FontMetrics fm = g.getFontMetrics(font);
                    Rectangle2D.Double clipRect = new Rectangle2D.Double(2.0, 2.0, width - 4.0, height - 4.0);
                    g.clip(clipRect);
                    g.setFont(font);
                    Rectangle2D stringRect = fm.getStringBounds(text, g);
                    float x = (float)((width - 4.0) / 2.0) - (float)stringRect.getWidth() / 2.0f;
                    g.drawString(text, x, (float)height - 6.0f);
                } else {
                    Rectangle2D.Double clipRect = new Rectangle2D.Double(2.0, 2.0, width - 4.0, height - 4.0);
                    g.clip(clipRect);
                    g.setFont(selectedFont);
                    FontMetrics fm = g.getFontMetrics(selectedFont);
                    Rectangle2D stringRect = fm.getStringBounds(text, g);
                    float x = (float)((width - 4.0) / 2.0) - (float)stringRect.getWidth() / 2.0f;
                    g.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    g.setColor(colors.TEXT_WHITE);
                    g.drawString(text, x + 1.0f, (float)height - 6.0f + 1.0f);
                    g.setColor(colors.TEXT_BLACK);
                    g.drawString(text, x, (float)height - 6.0f);
                }
            }
        }
    }
}

